/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBinarySubType;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.internal.io.AbstractBsonReader;
import org.mongodb.kbson.internal.io.BsonContextType;
import org.mongodb.kbson.internal.io.ByteArrayBsonInput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 12\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u0016H\u0014J\b\u0010\u001f\u001a\u00020\u0016H\u0014J\b\u0010 \u001a\u00020\u0016H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u0016H\u0014J\b\u0010&\u001a\u00020\u0016H\u0014J\b\u0010'\u001a\u00020\u001cH\u0014J\b\u0010(\u001a\u00020\u001cH\u0014J\b\u0010)\u001a\u00020\u0010H\u0014J\b\u0010*\u001a\u00020\u0016H\u0014J\b\u0010+\u001a\u00020\u0016H\u0014J\b\u0010,\u001a\u00020\u0016H\u0014J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u00060\u0006R\u00020\u00002\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0007\u0010\b\u00a8\u00062"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryReader;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader;", "bsonInput", "Lorg/mongodb/kbson/internal/io/ByteArrayBsonInput;", "(Lorg/mongodb/kbson/internal/io/ByteArrayBsonInput;)V", "context", "Lorg/mongodb/kbson/internal/io/BsonBinaryReader$BsonBinaryReaderContext;", "setContext", "(Lorg/mongodb/kbson/internal/io/BsonBinaryReader$BsonBinaryReaderContext;)V", "doReadBinaryData", "Lorg/mongodb/kbson/BsonBinary;", "doReadBoolean", "", "doReadDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doReadDateTime", "", "doReadDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doReadDouble", "", "doReadEndArray", "", "doReadEndDocument", "doReadInt32", "", "doReadInt64", "doReadJavaScript", "", "doReadJavaScriptWithScope", "doReadMaxKey", "doReadMinKey", "doReadNull", "doReadObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doReadRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doReadStartArray", "doReadStartDocument", "doReadString", "doReadSymbol", "doReadTimestamp", "doReadUndefined", "doSkipName", "doSkipValue", "readBsonType", "Lorg/mongodb/kbson/BsonType;", "readSize", "BsonBinaryReaderContext", "Companion", "kbson_debug"})
public final class BsonBinaryReader
extends AbstractBsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteArrayBsonInput bsonInput;
    @NotNull
    private BsonBinaryReaderContext context;

    public BsonBinaryReader(@NotNull ByteArrayBsonInput bsonInput) {
        Intrinsics.checkNotNullParameter((Object)bsonInput, (String)"bsonInput");
        this.bsonInput = bsonInput;
        this.context = new BsonBinaryReaderContext(null, BsonContextType.TOP_LEVEL, 0, 0);
    }

    private final void setContext(BsonBinaryReaderContext context) {
        this.set_context(context);
        this.context = context;
    }

    @Override
    protected void doReadStartDocument() {
        BsonContextType contextType = this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        int startPosition = this.bsonInput.getPosition();
        int size = this.readSize();
        this.setContext(new BsonBinaryReaderContext(this.context, contextType, startPosition, size));
    }

    @Override
    protected void doReadEndDocument() {
        this.setContext(this.context.popContext(this.bsonInput.getPosition()));
        if (this.context.getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            this.setContext(this.context.popContext(this.bsonInput.getPosition()));
        }
    }

    @Override
    protected void doReadStartArray() {
        int startPosition = this.bsonInput.getPosition();
        int size = this.readSize();
        this.setContext(new BsonBinaryReaderContext(this.context, BsonContextType.ARRAY, startPosition, size));
    }

    @Override
    protected void doReadEndArray() {
        this.setContext(this.context.popContext(this.bsonInput.getPosition()));
    }

    @Override
    @NotNull
    protected BsonBinary doReadBinaryData() {
        int numBytes = this.readSize();
        byte type = this.bsonInput.readByte();
        if (type == BsonBinarySubType.OLD_BINARY.getValue()) {
            int repeatedNumBytes = this.bsonInput.readInt32();
            boolean value$iv = repeatedNumBytes == numBytes - 4;
            boolean $i$f$validateSerialization = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Binary sub type OldBinary has inconsistent sizes";
                throw new BsonSerializationException(message$iv.toString(), null, 2, null);
            }
            numBytes -= 4;
        }
        return new BsonBinary(type, this.bsonInput.readBytes(new byte[numBytes]));
    }

    @Override
    protected boolean doReadBoolean() {
        byte booleanByte = this.bsonInput.readByte();
        boolean value$iv = booleanByte == 0 || booleanByte == 1;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = Intrinsics.stringPlus((String)"Expected a boolean value but found ", (Object)booleanByte);
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        return booleanByte == 1;
    }

    @Override
    protected long doReadDateTime() {
        return this.bsonInput.readInt64();
    }

    @Override
    protected double doReadDouble() {
        return this.bsonInput.readDouble();
    }

    @Override
    protected int doReadInt32() {
        return this.bsonInput.readInt32();
    }

    @Override
    protected long doReadInt64() {
        return this.bsonInput.readInt64();
    }

    @Override
    @NotNull
    protected BsonDecimal128 doReadDecimal128() {
        long low = this.bsonInput.readInt64();
        long high = this.bsonInput.readInt64();
        return BsonDecimal128.Companion.fromIEEE754BIDEncoding-PWzV0Is(ULong.constructor-impl((long)high), ULong.constructor-impl((long)low));
    }

    @Override
    @NotNull
    protected String doReadJavaScript() {
        return this.bsonInput.readString();
    }

    @Override
    @NotNull
    protected String doReadJavaScriptWithScope() {
        int startPosition = this.bsonInput.getPosition();
        int size = this.readSize();
        this.setContext(new BsonBinaryReaderContext(this.context, BsonContextType.JAVASCRIPT_WITH_SCOPE, startPosition, size));
        return this.bsonInput.readString();
    }

    @Override
    protected void doReadMaxKey() {
    }

    @Override
    protected void doReadMinKey() {
    }

    @Override
    protected void doReadNull() {
    }

    @Override
    @NotNull
    protected BsonObjectId doReadObjectId() {
        return this.bsonInput.readObjectId();
    }

    @Override
    @NotNull
    protected BsonRegularExpression doReadRegularExpression() {
        return new BsonRegularExpression(this.bsonInput.readCString(), this.bsonInput.readCString());
    }

    @Override
    @NotNull
    protected BsonDBPointer doReadDBPointer() {
        return new BsonDBPointer(this.bsonInput.readString(), this.bsonInput.readObjectId());
    }

    @Override
    @NotNull
    protected String doReadString() {
        return this.bsonInput.readString();
    }

    @Override
    @NotNull
    protected String doReadSymbol() {
        return this.bsonInput.readString();
    }

    @Override
    protected long doReadTimestamp() {
        return this.bsonInput.readInt64();
    }

    @Override
    protected void doReadUndefined() {
    }

    @Override
    protected void doSkipName() {
    }

    @Override
    protected void doSkipValue() {
        int n;
        boolean value$iv = this.getState() == AbstractBsonReader.State.VALUE;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "skipValue can only be called when State is " + (Object)((Object)AbstractBsonReader.State.VALUE) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        BsonType bsonType = this.getCurrentBsonType();
        switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
            case 1: {
                n = this.readSize() - 4;
                break;
            }
            case 2: {
                n = this.readSize() + 1;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 8;
                break;
            }
            case 5: {
                n = this.readSize() - 4;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            case 9: {
                n = 16;
                break;
            }
            case 10: {
                n = this.readSize();
                break;
            }
            case 11: {
                n = this.readSize() - 4;
                break;
            }
            case 12: {
                n = 0;
                break;
            }
            case 13: {
                n = 0;
                break;
            }
            case 14: {
                n = 0;
                break;
            }
            case 15: {
                n = 12;
                break;
            }
            case 16: {
                this.bsonInput.skipCString();
                this.bsonInput.skipCString();
                n = 0;
                break;
            }
            case 17: {
                n = this.readSize();
                break;
            }
            case 18: {
                n = this.readSize();
                break;
            }
            case 19: {
                n = 8;
                break;
            }
            case 20: {
                n = 0;
                break;
            }
            case 21: {
                n = this.readSize() + 12;
                break;
            }
            default: {
                throw new BsonSerializationException(Intrinsics.stringPlus((String)"Unexpected BSON type: ", (Object)((Object)this.getCurrentBsonType())), null, 2, null);
            }
        }
        int skip = n;
        this.bsonInput.skip(skip);
        this.setState(AbstractBsonReader.State.TYPE);
    }

    @Override
    @NotNull
    public BsonType readBsonType() {
        BsonType bsonType;
        BsonType bsonType2;
        byte bsonTypeByte;
        block11: {
            if (!(!this.isClosed())) {
                boolean $i$a$-check-BsonBinaryReader$readBsonType$22 = false;
                String $i$a$-check-BsonBinaryReader$readBsonType$22 = "BsonBinaryReader";
                throw new IllegalStateException($i$a$-check-BsonBinaryReader$readBsonType$22.toString());
            }
            if (this.getState() == AbstractBsonReader.State.INITIAL || this.getState() == AbstractBsonReader.State.DONE || this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT) {
                this.setCurrentBsonType(BsonType.DOCUMENT);
                this.setState(AbstractBsonReader.State.VALUE);
                BsonType bsonType3 = this.getCurrentBsonType();
                Intrinsics.checkNotNull((Object)((Object)bsonType3));
                return bsonType3;
            }
            boolean value$iv = this.getState() == AbstractBsonReader.State.TYPE;
            boolean $i$f$validateOperation = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "readBsonType can only be called when State is " + (Object)((Object)AbstractBsonReader.State.TYPE) + ", not when State is " + (Object)((Object)this.getState()) + '.';
                throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
            }
            bsonTypeByte = UByte.constructor-impl((byte)this.bsonInput.readByte());
            for (BsonType bsonType4 : BsonType.values()) {
                BsonType it = bsonType4;
                boolean bl = false;
                if (!(it.getValue-w2LRezQ() == bsonTypeByte)) continue;
                bsonType2 = bsonType4;
                break block11;
            }
            bsonType2 = null;
        }
        BsonType bsonType5 = bsonType2;
        boolean value$iv = bsonType5 != null;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Detected unknown BSON type '" + UByte.toString-impl((byte)bsonTypeByte) + "' for field name \"" + this.bsonInput.readCString() + "\". ";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        this.setCurrentBsonType(bsonType5);
        switch (WhenMappings.$EnumSwitchMapping$1[this.context.getContextType().ordinal()]) {
            case 1: {
                if (this.getCurrentBsonType() == BsonType.END_OF_DOCUMENT) {
                    this.setState(AbstractBsonReader.State.END_OF_ARRAY);
                    bsonType = BsonType.END_OF_DOCUMENT;
                    break;
                }
                this.bsonInput.skipCString();
                this.setState(AbstractBsonReader.State.VALUE);
                BsonType bsonType6 = this.getCurrentBsonType();
                bsonType = bsonType6;
                Intrinsics.checkNotNull((Object)((Object)bsonType6));
                break;
            }
            case 2: 
            case 3: {
                if (this.getCurrentBsonType() == BsonType.END_OF_DOCUMENT) {
                    this.setState(AbstractBsonReader.State.END_OF_DOCUMENT);
                    bsonType = BsonType.END_OF_DOCUMENT;
                    break;
                }
                this.setCurrentName(this.bsonInput.readCString());
                this.setState(AbstractBsonReader.State.NAME);
                BsonType bsonType7 = this.getCurrentBsonType();
                bsonType = bsonType7;
                Intrinsics.checkNotNull((Object)((Object)bsonType7));
                break;
            }
            default: {
                throw new BsonSerializationException(Intrinsics.stringPlus((String)"BsonType EndOfDocument is not valid when ContextType is ", (Object)((Object)this.context.getContextType())), null, 2, null);
            }
        }
        return bsonType;
    }

    private final int readSize() {
        int size = this.bsonInput.readInt32();
        boolean value$iv = size >= 0;
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Size " + size + " is not valid because it is negative.";
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        return size;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryReader$Companion;", "", "()V", "invoke", "Lorg/mongodb/kbson/internal/io/BsonBinaryReader;", "byteArray", "", "kbson_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BsonBinaryReader invoke(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            return new BsonBinaryReader(new ByteArrayBsonInput(byteArray, 0, 2, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B+\u0012\f\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00060\u0000R\u00020\u00042\u0006\u0010\f\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/mongodb/kbson/internal/io/BsonBinaryReader$BsonBinaryReaderContext;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader;", "parentContext", "Lorg/mongodb/kbson/internal/io/BsonBinaryReader;", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "startPosition", "", "size", "(Lorg/mongodb/kbson/internal/io/BsonBinaryReader;Lorg/mongodb/kbson/internal/io/BsonBinaryReader$BsonBinaryReaderContext;Lorg/mongodb/kbson/internal/io/BsonContextType;II)V", "popContext", "position", "kbson_debug"})
    private final class BsonBinaryReaderContext
    extends AbstractBsonReader.Context {
        @Nullable
        private final BsonBinaryReaderContext parentContext;
        private final int startPosition;
        private final int size;

        public BsonBinaryReaderContext(@NotNull BsonBinaryReaderContext parentContext, BsonContextType contextType, int startPosition, int size) {
            Intrinsics.checkNotNullParameter((Object)BsonBinaryReader.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            super(contextType);
            this.parentContext = parentContext;
            this.startPosition = startPosition;
            this.size = size;
        }

        @NotNull
        public final BsonBinaryReaderContext popContext(int position) {
            int actualSize = position - this.startPosition;
            boolean value$iv = actualSize == this.size;
            boolean $i$f$validateSerialization = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Expected size to be " + this.size + ", not " + actualSize + '.';
                throw new BsonSerializationException(message$iv.toString(), null, 2, null);
            }
            value$iv = this.parentContext != null;
            $i$f$validateSerialization = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Missing parent context.";
                throw new BsonSerializationException(message$iv.toString(), null, 2, null);
            }
            return this.parentContext;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[BsonType.values().length];
            nArray[BsonType.ARRAY.ordinal()] = 1;
            nArray[BsonType.BINARY.ordinal()] = 2;
            nArray[BsonType.BOOLEAN.ordinal()] = 3;
            nArray[BsonType.DATE_TIME.ordinal()] = 4;
            nArray[BsonType.DOCUMENT.ordinal()] = 5;
            nArray[BsonType.DOUBLE.ordinal()] = 6;
            nArray[BsonType.INT32.ordinal()] = 7;
            nArray[BsonType.INT64.ordinal()] = 8;
            nArray[BsonType.DECIMAL128.ordinal()] = 9;
            nArray[BsonType.JAVASCRIPT.ordinal()] = 10;
            nArray[BsonType.JAVASCRIPT_WITH_SCOPE.ordinal()] = 11;
            nArray[BsonType.MAX_KEY.ordinal()] = 12;
            nArray[BsonType.MIN_KEY.ordinal()] = 13;
            nArray[BsonType.NULL.ordinal()] = 14;
            nArray[BsonType.OBJECT_ID.ordinal()] = 15;
            nArray[BsonType.REGULAR_EXPRESSION.ordinal()] = 16;
            nArray[BsonType.STRING.ordinal()] = 17;
            nArray[BsonType.SYMBOL.ordinal()] = 18;
            nArray[BsonType.TIMESTAMP.ordinal()] = 19;
            nArray[BsonType.UNDEFINED.ordinal()] = 20;
            nArray[BsonType.DB_POINTER.ordinal()] = 21;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BsonContextType.values().length];
            nArray[BsonContextType.ARRAY.ordinal()] = 1;
            nArray[BsonContextType.DOCUMENT.ordinal()] = 2;
            nArray[BsonContextType.SCOPE_DOCUMENT.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

