/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.serialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonArrayEncoder;
import org.mongodb.kbson.serialization.BsonClassEncoder;
import org.mongodb.kbson.serialization.BsonDocumentEncoder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u0006H&J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006H&R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002+,\u00a8\u0006-"}, d2={"Lorg/mongodb/kbson/serialization/BsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "nodeConsumer", "Lkotlin/Function1;", "Lorg/mongodb/kbson/BsonValue;", "", "(Lkotlinx/serialization/modules/SerializersModule;Lkotlin/jvm/functions/Function1;)V", "getNodeConsumer", "()Lkotlin/jvm/functions/Function1;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "value", "", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "", "endStructure", "getCurrent", "pushValue", "Lorg/mongodb/kbson/serialization/PrimitiveBsonEncoder;", "Lorg/mongodb/kbson/serialization/StructuredBsonEncoder;", "kbson_debug"})
public abstract class BsonEncoder
extends AbstractEncoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final Function1<BsonValue, Unit> nodeConsumer;

    private BsonEncoder(SerializersModule serializersModule, Function1<? super BsonValue, Unit> nodeConsumer) {
        this.serializersModule = serializersModule;
        this.nodeConsumer = nodeConsumer;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final Function1<BsonValue, Unit> getNodeConsumer() {
        return this.nodeConsumer;
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new BsonArrayEncoder(this.getSerializersModule(), (Function1<? super BsonValue, Unit>)((Function1)new Function1<BsonValue, Unit>(this){
                final /* synthetic */ BsonEncoder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BsonValue it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.pushValue(it);
                }
            }));
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new BsonClassEncoder(this.getSerializersModule(), (Function1<? super BsonValue, Unit>)((Function1)new Function1<BsonValue, Unit>(this){
                final /* synthetic */ BsonEncoder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BsonValue it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.pushValue(it);
                }
            }));
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new BsonDocumentEncoder(this.getSerializersModule(), (Function1<? super BsonValue, Unit>)((Function1)new Function1<BsonValue, Unit>(this){
                final /* synthetic */ BsonEncoder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BsonValue it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.pushValue(it);
                }
            }));
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeEncoder = (CompositeEncoder)new BsonDocumentEncoder(this.getSerializersModule(), (Function1<? super BsonValue, Unit>)((Function1)new Function1<BsonValue, Unit>(this){
                final /* synthetic */ BsonEncoder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BsonValue it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.pushValue(new BsonDocument(null, 1, null));
                }
            }));
        } else {
            if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE) ? true : Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
                throw new SerializationException("Polymorphic values are not supported.");
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unsupported descriptor Kind ", (Object)descriptor.getKind()).toString());
        }
        return compositeEncoder;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.nodeConsumer.invoke((Object)this.getCurrent());
    }

    public void encodeInt(int value) {
        this.pushValue(new BsonInt32(value));
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pushValue(new BsonString(value));
    }

    public void encodeBoolean(boolean value) {
        this.pushValue(new BsonBoolean(value));
    }

    public void encodeByte(byte value) {
        this.pushValue(new BsonInt32(value));
    }

    public void encodeChar(char value) {
        this.pushValue(new BsonString(String.valueOf(value)));
    }

    public void encodeDouble(double value) {
        this.pushValue(new BsonDouble(value));
    }

    public void encodeFloat(float value) {
        this.pushValue(new BsonDouble(value));
    }

    public void encodeLong(long value) {
        this.pushValue(new BsonInt64(value));
    }

    public void encodeShort(short value) {
        this.pushValue(new BsonInt32(value));
    }

    public void encodeNull() {
        this.pushValue(BsonNull.INSTANCE);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.pushValue(new BsonString(enumDescriptor.getElementName(index)));
    }

    @NotNull
    public abstract BsonValue getCurrent();

    public abstract void pushValue(@NotNull BsonValue var1);

    public /* synthetic */ BsonEncoder(SerializersModule serializersModule, Function1 nodeConsumer, DefaultConstructorMarker $constructor_marker) {
        this(serializersModule, (Function1<? super BsonValue, Unit>)nodeConsumer);
    }
}

