/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import com.mongodb.internal.async.client.MappingIterable;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.List;

abstract class AsyncMongoIterableImpl<TResult>
implements AsyncMongoIterable<TResult> {
    private final AsyncClientSession clientSession;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private Integer batchSize;

    AsyncMongoIterableImpl(@Nullable AsyncClientSession clientSession, OperationExecutor executor, ReadConcern readConcern, ReadPreference readPreference, boolean retryReads) {
        this.clientSession = clientSession;
        this.executor = Assertions.notNull("executor", executor);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.retryReads = Assertions.notNull("retryReads", retryReads);
    }

    abstract AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation();

    public AsyncClientSession getClientSession() {
        return this.clientSession;
    }

    OperationExecutor getExecutor() {
        return this.executor;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void forEach(final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull("block", block);
        Assertions.notNull("callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            @Override
            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    AsyncMongoIterableImpl.this.loopCursor(batchCursor, block, callback);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super TResult>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull("target", target);
        Assertions.notNull("callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            @Override
            public void onResult(AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    AsyncMongoIterableImpl.this.loopCursor(batchCursor, new Block<TResult>(){

                        @Override
                        public void apply(TResult t) {
                            target.add(t);
                        }
                    }, new SingleResultCallback<Void>(){

                        @Override
                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult(target, null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void first(final SingleResultCallback<TResult> callback) {
        Assertions.notNull("callback", callback);
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            @Override
            public void onResult(final AsyncBatchCursor<TResult> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.setBatchSize(1);
                    batchCursor.next(new SingleResultCallback<List<TResult>>(){

                        @Override
                        public void onResult(List<TResult> results, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (results == null) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(results.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <U> AsyncMongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public AsyncMongoIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<TResult>> callback) {
        Assertions.notNull("callback", callback);
        this.executor.execute(this.asAsyncReadOperation(), this.readPreference, this.readConcern, this.clientSession, callback);
    }

    private void loopCursor(final AsyncBatchCursor<TResult> batchCursor, final Block<? super TResult> block, final SingleResultCallback<Void> callback) {
        batchCursor.next(new SingleResultCallback<List<TResult>>(){

            @Override
            public void onResult(List<TResult> results, Throwable t) {
                if (t != null || results == null) {
                    batchCursor.close();
                    callback.onResult(null, t);
                } else {
                    try {
                        for (Object result : results) {
                            block.apply(result);
                        }
                        AsyncMongoIterableImpl.this.loopCursor(batchCursor, block, callback);
                    }
                    catch (Throwable tr) {
                        batchCursor.close();
                        callback.onResult(null, tr);
                    }
                }
            }
        });
    }
}

