/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncClientSessionImpl;
import com.mongodb.internal.async.client.AsyncMongoClientImpl;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.List;

class ClientSessionHelper {
    private final AsyncMongoClientImpl mongoClient;
    private final ServerSessionPool serverSessionPool;

    ClientSessionHelper(AsyncMongoClientImpl mongoClient, ServerSessionPool serverSessionPool) {
        this.mongoClient = mongoClient;
        this.serverSessionPool = serverSessionPool;
    }

    void withClientSession(@Nullable AsyncClientSession clientSessionFromOperation, OperationExecutor executor, SingleResultCallback<AsyncClientSession> callback) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue("ClientSession from same MongoClient", clientSessionFromOperation.getOriginator() == this.mongoClient);
            callback.onResult(clientSessionFromOperation, null);
        } else {
            this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), executor, callback);
        }
    }

    void createClientSession(final ClientSessionOptions options, final OperationExecutor executor, final SingleResultCallback<AsyncClientSession> callback) {
        ClusterDescription clusterDescription = this.mongoClient.getCluster().getCurrentDescription();
        if (!this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty() && clusterDescription.getLogicalSessionTimeoutMinutes() != null) {
            callback.onResult(this.createClientSession(options, executor), null);
        } else {
            this.mongoClient.getCluster().selectServerAsync(new ServerSelector(){

                @Override
                public List<ServerDescription> select(ClusterDescription clusterDescription) {
                    return ClientSessionHelper.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                }
            }, new SingleResultCallback<Server>(){

                @Override
                public void onResult(Server server, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, null);
                    } else if (server.getDescription().getLogicalSessionTimeoutMinutes() == null) {
                        callback.onResult(null, null);
                    } else {
                        callback.onResult(ClientSessionHelper.this.createClientSession(options, executor), null);
                    }
                }
            });
        }
    }

    private AsyncClientSession createClientSession(ClientSessionOptions options, OperationExecutor executor) {
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder(options).defaultTransactionOptions(TransactionOptions.merge(options.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(this.mongoClient.getSettings().getReadConcern()).writeConcern(this.mongoClient.getSettings().getWriteConcern()).readPreference(this.mongoClient.getSettings().getReadPreference()).build())).build();
        return new AsyncClientSessionImpl(this.serverSessionPool, this.mongoClient, mergedOptions, executor);
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return ClusterDescriptionHelper.getAnyPrimaryOrSecondary(clusterDescription);
    }
}

