/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class DropSearchIndexOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "dropSearchIndex";
    private final String indexName;

    DropSearchIndexOperation(MongoNamespace namespace, String indexName, WriteConcern writeConcern) {
        super(namespace, writeConcern);
        this.indexName = indexName;
    }

    @Override
    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null && !CommandOperationHelper.isNamespaceError(mongoExecutionException)) {
            throw mongoExecutionException;
        }
    }

    @Override
    BsonDocument buildCommand() {
        BsonDocument command = new BsonDocument(COMMAND_NAME, (BsonValue)new BsonString(this.getNamespace().getCollectionName())).append("name", (BsonValue)new BsonString(this.indexName));
        WriteConcernHelper.appendWriteConcernToCommand(this.getWriteConcern(), command);
        return command;
    }
}

