/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcernResult;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;

final class FindAndModifyHelper {
    static <T> SyncOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    static <T> AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    @Nullable
    private static <T> T transformDocument(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            MongoWriteConcernException writeConcernException = new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument((Object)"writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument((Object)"lastErrorObject", new BsonDocument())), serverAddress);
            result.getArray((Object)"errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).forEach(writeConcernException::addLabel);
            throw writeConcernException;
        }
        if (!result.isDocument((Object)"value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result.getDocument((Object)"value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean((Object)"updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber((Object)"n", (BsonNumber)new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get((Object)"upserted"));
    }

    private FindAndModifyHelper() {
    }
}

