/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.query.dsql.parser;

import java.util.List;
import java.util.Stack;
import org.mule.common.query.DefaultQueryBuilder;
import org.mule.common.query.Field;
import org.mule.common.query.QueryBuilder;
import org.mule.common.query.Type;
import org.mule.common.query.dsql.parser.AndDsqlNode;
import org.mule.common.query.dsql.parser.DirectionDsqlNode;
import org.mule.common.query.dsql.parser.DsqlGrammarVisitor;
import org.mule.common.query.dsql.parser.DsqlNode;
import org.mule.common.query.dsql.parser.ExpressionDsqlNode;
import org.mule.common.query.dsql.parser.FromDsqlNode;
import org.mule.common.query.dsql.parser.IDsqlNode;
import org.mule.common.query.dsql.parser.LimitDsqlNode;
import org.mule.common.query.dsql.parser.NotDsqlNode;
import org.mule.common.query.dsql.parser.OffsetDsqlNode;
import org.mule.common.query.dsql.parser.OpeningParenthesesDsqlNode;
import org.mule.common.query.dsql.parser.OperatorDsqlNode;
import org.mule.common.query.dsql.parser.OrDsqlNode;
import org.mule.common.query.dsql.parser.OrderByDsqlNode;
import org.mule.common.query.dsql.parser.QueryModelDirectionFactory;
import org.mule.common.query.dsql.parser.QueryModelOperatorFactory;
import org.mule.common.query.dsql.parser.SelectDsqlNode;
import org.mule.common.query.expression.And;
import org.mule.common.query.expression.BinaryOperator;
import org.mule.common.query.expression.BooleanValue;
import org.mule.common.query.expression.DateTimeValue;
import org.mule.common.query.expression.DateValue;
import org.mule.common.query.expression.Expression;
import org.mule.common.query.expression.FieldComparation;
import org.mule.common.query.expression.IdentifierValue;
import org.mule.common.query.expression.IntegerValue;
import org.mule.common.query.expression.MuleExpressionValue;
import org.mule.common.query.expression.Not;
import org.mule.common.query.expression.NullValue;
import org.mule.common.query.expression.NumberValue;
import org.mule.common.query.expression.Or;
import org.mule.common.query.expression.StringValue;
import org.mule.common.query.expression.UnknownValue;
import org.mule.common.query.expression.Value;

public class DefaultDsqlGrammarVisitor
implements DsqlGrammarVisitor {
    private QueryBuilder queryBuilder;
    private Stack<Expression> expressions = new Stack();
    private int expressionLevel = 0;

    public DefaultDsqlGrammarVisitor() {
        this.queryBuilder = new DefaultQueryBuilder();
    }

    @Override
    public void visit(DsqlNode dsqlNode) {
    }

    @Override
    public void visit(SelectDsqlNode selectDsqlNode) {
        List<IDsqlNode> children = selectDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            if (dsqlNode.getType() != 27 && dsqlNode.getType() != 50 && dsqlNode.getType() != 6) {
                dsqlNode.accept(this);
                continue;
            }
            String nodeText = dsqlNode.getText();
            if (dsqlNode.getType() == 50) {
                nodeText = (String)StringValue.fromLiteral(nodeText).getValue();
            }
            this.queryBuilder.addField(new Field(nodeText, "string"));
        }
    }

    @Override
    public void visit(FromDsqlNode fromDsqlNode) {
        List<IDsqlNode> children = fromDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            String text = this.getTextIfStringLiteral(dsqlNode);
            this.queryBuilder.addType(new Type(text));
        }
    }

    private String getTextIfStringLiteral(IDsqlNode dsqlNode) {
        String text = dsqlNode.getText();
        if (dsqlNode.getType() == 50) {
            return (String)StringValue.fromLiteral(text).getValue();
        }
        return text;
    }

    @Override
    public void visit(ExpressionDsqlNode expressionDsqlNode) {
        List<IDsqlNode> children = expressionDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            int type = dsqlNode.getType();
            if (type == 4 || type == 43 || type == 37) {
                dsqlNode.accept(this);
                continue;
            }
            if (type == 42 || type == 13) {
                List<IDsqlNode> operatorChildren = dsqlNode.getChildren();
                IDsqlNode fieldNode = operatorChildren.get(0);
                String fieldName = this.getTextIfStringLiteral(fieldNode);
                Field field = new Field(fieldName);
                IDsqlNode valueNode = operatorChildren.get(1);
                Value value = this.buildValue(valueNode);
                FieldComparation expression = new FieldComparation(this.getOperatorFor(dsqlNode.getText()), field, value);
                this.queryBuilder.setFilterExpression(expression);
                continue;
            }
            if (type != 41) continue;
            dsqlNode.accept(this);
        }
    }

    private Value buildValue(IDsqlNode node) {
        Value value;
        switch (node.getType()) {
            case 18: {
                value = NumberValue.fromLiteral(node.getText());
                break;
            }
            case 28: {
                value = IntegerValue.fromLiteral(node.getText());
                break;
            }
            case 8: {
                value = BooleanValue.fromLiteral(node.getText());
                break;
            }
            case 15: {
                value = DateValue.fromLiteral(node.getText());
                break;
            }
            case 16: {
                value = DateTimeValue.fromLiteral(node.getText());
                break;
            }
            case 38: {
                value = new NullValue();
                break;
            }
            case 27: {
                value = IdentifierValue.fromLiteral(node.getText());
                break;
            }
            case 34: {
                value = MuleExpressionValue.fromLiteral(node.getText());
                break;
            }
            case 50: {
                value = StringValue.fromLiteral(node.getText());
                break;
            }
            default: {
                value = UnknownValue.fromLiteral(node.getText());
            }
        }
        return value;
    }

    @Override
    public void visit(AndDsqlNode andDsqlNode) {
        List<IDsqlNode> children = andDsqlNode.getChildren();
        ++this.expressionLevel;
        for (IDsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression rightExpression = this.expressions.pop();
        Expression leftExpression = this.expressions.pop();
        And andExpression = new And(leftExpression, rightExpression);
        this.putExpression(andExpression);
    }

    private void putExpression(Expression expression) {
        if (this.expressionLevel == 0) {
            this.queryBuilder.setFilterExpression(expression);
        } else {
            this.expressions.push(expression);
        }
    }

    @Override
    public void visit(OrDsqlNode orDsqlNode) {
        List<IDsqlNode> children = orDsqlNode.getChildren();
        ++this.expressionLevel;
        for (IDsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression rightExpression = this.expressions.pop();
        Expression leftExpression = this.expressions.pop();
        this.putExpression(new Or(leftExpression, rightExpression));
    }

    @Override
    public void visit(NotDsqlNode notDsqlNode) {
        List<IDsqlNode> children = notDsqlNode.getChildren();
        ++this.expressionLevel;
        for (IDsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
        --this.expressionLevel;
        Expression expression = this.expressions.pop();
        this.putExpression(new Not(expression));
    }

    @Override
    public void visit(OperatorDsqlNode operatorDsqlNode) {
        List<IDsqlNode> children = operatorDsqlNode.getChildren();
        IDsqlNode fieldNode = children.get(0);
        Field field = new Field(this.getTextIfStringLiteral(fieldNode));
        IDsqlNode dsqlNode = children.get(1);
        Value value = this.buildValue(dsqlNode);
        this.putExpression(new FieldComparation(this.getOperatorFor(operatorDsqlNode.getText()), field, value));
    }

    @Override
    public void visit(OpeningParenthesesDsqlNode openingParenthesesDsqlNode) {
        List<IDsqlNode> children = openingParenthesesDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            dsqlNode.accept(this);
        }
    }

    private BinaryOperator getOperatorFor(String symbol) {
        return (BinaryOperator)QueryModelOperatorFactory.getInstance().getOperator(symbol);
    }

    @Override
    public void visit(OrderByDsqlNode orderByDsqlNode) {
        List<IDsqlNode> children = orderByDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            String text = this.getTextIfStringLiteral(dsqlNode);
            if (!(dsqlNode instanceof DirectionDsqlNode)) {
                this.queryBuilder.addOrderByField(new Field(text));
                continue;
            }
            this.queryBuilder.setDirection(QueryModelDirectionFactory.getInstance().getDirection(text.toLowerCase()));
        }
    }

    @Override
    public void visit(LimitDsqlNode limitDsqlNode) {
        List<IDsqlNode> children = limitDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            this.queryBuilder.setLimit(Integer.parseInt(dsqlNode.getText()));
        }
    }

    @Override
    public void visit(OffsetDsqlNode offsetDsqlNode) {
        List<IDsqlNode> children = offsetDsqlNode.getChildren();
        for (IDsqlNode dsqlNode : children) {
            this.queryBuilder.setOffset(Integer.parseInt(dsqlNode.getText()));
        }
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }
}

