/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.mule.common.metadata.MetaDataProperty;
import org.mule.common.metadata.property.exception.RepeatedPropertyException;

public class MetaDataPropertyManager<C extends MetaDataProperty> {
    private List<C> properties;

    public MetaDataPropertyManager(List<C> properties) {
        this.setProperties(properties);
    }

    public MetaDataPropertyManager() {
        this(new ArrayList());
    }

    public boolean hasProperty(Class<? extends MetaDataProperty> fieldProperty) {
        return this.getProperty(fieldProperty) != null;
    }

    public <T extends MetaDataProperty> T getProperty(Class<T> propertyClass) {
        for (MetaDataProperty fc : this.properties) {
            if (!propertyClass.equals(fc.getClass())) continue;
            return (T)fc;
        }
        return null;
    }

    public boolean addProperty(C property) {
        Class<?> fieldPropertyClass = property.getClass();
        if (this.hasProperty(fieldPropertyClass)) {
            Object alreadyDefinedProperty = this.getProperty(fieldPropertyClass);
            this.removeProperty(alreadyDefinedProperty);
        }
        return this.properties.add(property);
    }

    public boolean removeProperty(C property) {
        if (this.properties.contains(property)) {
            return this.properties.remove(property);
        }
        return false;
    }

    public List<C> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    private void setProperties(List<C> properties) {
        if (this.hasRepeatedProperties(properties)) {
            throw new RepeatedPropertyException("Properties must no be repeated");
        }
        this.properties = new ArrayList<C>(properties);
    }

    private boolean hasRepeatedProperties(List<C> properties) {
        HashSet clazzes = new HashSet();
        for (MetaDataProperty fc : properties) {
            clazzes.add(fc.getClass());
        }
        return clazzes.size() != properties.size();
    }
}

