/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.HashMap;
import java.util.List;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultQueryResultMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.ListMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelVisitor;
import org.mule.common.metadata.ParameterizedMapMetaDataModel;
import org.mule.common.metadata.PojoMetaDataModel;
import org.mule.common.metadata.SimpleMetaDataModel;
import org.mule.common.metadata.UnknownMetaDataModel;
import org.mule.common.metadata.XmlMetaDataModel;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.query.Field;

public class MetaDataQueryFilterVisitor
implements MetaDataModelVisitor {
    private List<Field> fields;
    private MetaDataModel resultModel;

    public MetaDataQueryFilterVisitor(List<Field> fields) {
        this.fields = fields;
        this.resultModel = new DefaultSimpleMetaDataModel(DataType.VOID);
    }

    @Override
    public void visitPojoModel(PojoMetaDataModel pojoMetaDataModel) {
        this.resultModel = pojoMetaDataModel;
    }

    @Override
    public void visitListMetaDataModel(ListMetaDataModel listMetaDataModel) {
        MetaDataQueryFilterVisitor child = new MetaDataQueryFilterVisitor(this.fields);
        listMetaDataModel.getElementModel().accept(child);
        this.resultModel = new DefaultListMetaDataModel(child.filteringResult().getPayload());
    }

    @Override
    public void visitSimpleMetaDataModel(SimpleMetaDataModel simpleMetaDataModel) {
        this.resultModel = simpleMetaDataModel;
    }

    @Override
    public void visitStaticMapModel(ParameterizedMapMetaDataModel parameterizedMapMetaDataModel) {
        this.resultModel = parameterizedMapMetaDataModel;
    }

    @Override
    public void visitXmlMetaDataModel(XmlMetaDataModel xmlMetaDataModel) {
        this.resultModel = xmlMetaDataModel;
    }

    @Override
    public void visitUnknownMetaDataModel(UnknownMetaDataModel unknownMetaDataModel) {
        this.resultModel = unknownMetaDataModel;
    }

    @Override
    public void visitDynamicMapModel(DefinedMapMetaDataModel definedMapMetaDataModel) {
        if (this.fields == null) {
            return;
        }
        HashMap<String, MetaDataModel> newMapModel = new HashMap<String, MetaDataModel>();
        for (Field f : this.fields) {
            MetaDataModel fieldModel = definedMapMetaDataModel.getValueMetaDataModel(f.getName());
            if (fieldModel == null) continue;
            newMapModel.put(f.getName(), fieldModel);
        }
        this.resultModel = new DefaultQueryResultMetaDataModel(new DefaultDefinedMapMetaDataModel(newMapModel, definedMapMetaDataModel.getName()));
    }

    public MetaData filteringResult() {
        return new DefaultMetaData(this.resultModel);
    }
}

