/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.JSONArrayType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONPointerType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.OptionalType;
import org.mule.common.metadata.parser.json.SchemaException;

public class SchemaEnv {
    private SchemaEnv parent = null;
    private Map<String, JSONType> types = new TreeMap<String, JSONType>();
    private URL contextJsonURL = null;
    private JSONObject contextJsonObject = null;

    public SchemaEnv() {
        this.types.put("string", new JSONType.StringType());
        this.types.put("integer", new JSONType.IntegerType());
        this.types.put("double", new JSONType.DoubleType());
        this.types.put("boolean", new JSONType.BooleanType());
        this.types.put("number", new JSONType.NumberType());
    }

    public SchemaEnv(SchemaEnv p) {
        this();
        this.parent = p;
    }

    public SchemaEnv(SchemaEnv p, JSONObject contextJsonObject) {
        this(p);
        this.contextJsonObject = contextJsonObject;
    }

    public SchemaEnv(JSONObject contextJsonObject, URL contextJsonURL) {
        this(null, contextJsonObject);
        this.contextJsonURL = contextJsonURL;
    }

    public JSONObject getContextJsonObject() {
        return this.contextJsonObject;
    }

    public JSONType lookupType(String name) {
        if (this.types.containsKey(name)) {
            return this.types.get(name);
        }
        if (this.parent != null) {
            return this.parent.lookupType(name);
        }
        return null;
    }

    public JSONType evaluate(Object obj) throws SchemaException {
        try {
            if (obj == null) {
                throw new IllegalArgumentException("null schema object.");
            }
            if (obj instanceof String) {
                String name = (String)obj;
                JSONType type = this.lookupType(name);
                if (type == null) {
                    throw new SchemaException(String.format("Unknown type name \"%s\"", name));
                }
                return type;
            }
            if (obj instanceof JSONObject) {
                JSONObject json = (JSONObject)obj;
                boolean optional = json.has("optional") ? json.getBoolean("optional") : false;
                JSONType specifiedType = null;
                if (json.has("type")) {
                    Object rawType = json.get("type");
                    if (rawType instanceof JSONArray) {
                        specifiedType = new JSONType.Everything();
                    } else if (rawType instanceof String) {
                        String type = json.getString("type").toLowerCase();
                        if (type.equals("array")) {
                            specifiedType = new JSONArrayType(new SchemaEnv(this, this.contextJsonObject), json);
                        } else if (type.equals("object")) {
                            specifiedType = new JSONObjectType(new SchemaEnv(this, this.contextJsonObject), json);
                        } else {
                            JSONType tt = this.lookupType(type);
                            if (tt == null) {
                                throw new SchemaException(String.format("Unrecognized schema type %s in %s", type, json.toString()));
                            }
                            specifiedType = tt;
                        }
                    }
                } else if (json.has("properties")) {
                    specifiedType = new JSONObjectType(new SchemaEnv(this, this.contextJsonObject), json);
                } else if (json.has("enum")) {
                    specifiedType = new JSONType.StringType();
                } else if (json.has("$ref")) {
                    String reference = json.getString("$ref");
                    specifiedType = new JSONPointerType(this, reference);
                } else if (json.has("anyOf") || json.has("allOf") || json.has("oneOf")) {
                    specifiedType = new JSONType.Everything();
                } else {
                    throw new SchemaException("Schema object doesn't contain a 'types' property. \nElement:\n" + obj);
                }
                return optional ? new OptionalType(specifiedType) : specifiedType;
            }
            if (obj instanceof JSONArray) {
                return new JSONType.Everything();
            }
            throw new IllegalArgumentException(obj.getClass().getSimpleName() + " isn't a valid schema type");
        }
        catch (JSONException e) {
            throw new SchemaException(String.valueOf(obj), e);
        }
    }

    public void addType(String name, JSONType t) {
        this.types.put(name, t);
    }

    public boolean containsType(String name) {
        return this.types.containsKey(name);
    }

    public Iterator<String> names() {
        return new TreeSet<String>(this.types.keySet()).iterator();
    }

    public SchemaEnv getParent() {
        return this.parent;
    }

    public URL getContextJsonURL() {
        return this.contextJsonURL;
    }
}

