/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.JSONMetaDataHelper;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataFieldFactory;

public class JSONSampleMetaDataFieldFactory
implements MetaDataFieldFactory {
    private ObjectNode jsonObject;

    public JSONSampleMetaDataFieldFactory(ObjectNode jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public List<MetaDataField> createFields() {
        ArrayList<MetaDataField> metaDataFields = new ArrayList<MetaDataField>();
        this.processObject(this.jsonObject, metaDataFields);
        return metaDataFields;
    }

    private void processObject(ObjectNode object, List<MetaDataField> metaDataFields) {
        Iterator fields = object.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            JSONSampleMetaDataFieldFactory.processElement((String)entry.getKey(), (JsonNode)entry.getValue(), metaDataFields);
        }
    }

    private static void processElement(String name, JsonNode element, List<MetaDataField> metaDataFields) {
        metaDataFields.add(new DefaultMetaDataField(name, JSONMetaDataHelper.buildModelFromNode(element)));
    }
}

