/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.util.Arrays;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JSONUtils {
    public static boolean isEqual(Object o1, Object o2) {
        if (o1 instanceof JSONObject) {
            if (!(o2 instanceof JSONObject)) {
                return false;
            }
            return JSONUtils.isJSONObjectEqual((JSONObject)o1, (JSONObject)o2);
        }
        if (o1 instanceof JSONArray) {
            JSONArray a1 = (JSONArray)o1;
            if (!(o2 instanceof JSONArray)) {
                return false;
            }
            JSONArray a2 = (JSONArray)o2;
            try {
                if (a1.length() != a2.length()) {
                    return false;
                }
                for (int i = 0; i < a1.length(); ++i) {
                    if (JSONUtils.isEqual(a1.get(i), a2.get(i))) continue;
                    return false;
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static boolean isJSONObjectEqual(JSONObject o1, JSONObject o2) {
        try {
            TreeSet<String> o1Keys = new TreeSet<String>(Arrays.asList(JSONObject.getNames((JSONObject)o1)));
            TreeSet<String> o2Keys = new TreeSet<String>(Arrays.asList(JSONObject.getNames((JSONObject)o2)));
            if (o1Keys.size() != o2Keys.size()) {
                return false;
            }
            for (String key : o1Keys) {
                if (!o2Keys.contains(key)) {
                    return false;
                }
                if (JSONUtils.isEqual(o1.get(key), o2.get(key))) continue;
                return false;
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
        return true;
    }
}

