/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.Operation;

public final class DataQualifierFactory {
    private static final DataTypeQualifierEvaluator BOOLEAN_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{Boolean.TYPE, Boolean.class}, DataQualifier.BOOLEAN);
    private static final DataTypeQualifierEvaluator STRING_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{String.class, Character.TYPE, Character.class}, DataQualifier.STRING);
    private static final DataTypeQualifierEvaluator INTEGER_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{Integer.TYPE, Short.TYPE, Integer.class, Short.class}, DataQualifier.INTEGER);
    private static final DataTypeQualifierEvaluator DOUBLE_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{Double.TYPE, Float.TYPE, Double.class, Float.class}, DataQualifier.DOUBLE);
    private static final DataTypeQualifierEvaluator LONG_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{Long.TYPE, Long.class}, DataQualifier.LONG);
    private static final DataTypeQualifierEvaluator DECIMAL_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{BigDecimal.class, BigInteger.class}, DataQualifier.DECIMAL);
    private static final DataTypeQualifierEvaluator DATE_TIME_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{java.util.Date.class, Date.class, Calendar.class, XMLGregorianCalendar.class, Time.class, Timestamp.class}, DataQualifier.DATE_TIME);
    private static final DataTypeQualifierEvaluator ENUM_EVALUATOR = new EnumDataTypeQualifierEvaluator();
    private static final DataTypeQualifierEvaluator LIST_EVALUATOR = new DefaultQualifierEvaluator(new Class[]{List.class, Set.class, Object[].class}, DataQualifier.LIST);
    private static final DataTypeQualifierEvaluator MAP_EVALUATOR = new DefaultQualifierEvaluator(Map.class, DataQualifier.MAP);
    private static final DataTypeQualifierEvaluator OPERATION_EVALUATOR = new DefaultQualifierEvaluator(Operation.class, DataQualifier.OPERATION);
    private static final DataTypeQualifierEvaluator POJO_EVALUATOR = new PojoTypeQualifierEvaluator();
    private static final DataTypeQualifierEvaluator[] evaluators = new DataTypeQualifierEvaluator[]{BOOLEAN_EVALUATOR, STRING_EVALUATOR, INTEGER_EVALUATOR, DOUBLE_EVALUATOR, LONG_EVALUATOR, DECIMAL_EVALUATOR, DATE_TIME_EVALUATOR, ENUM_EVALUATOR, LIST_EVALUATOR, MAP_EVALUATOR, OPERATION_EVALUATOR, POJO_EVALUATOR};

    public static DataQualifier getQualifier(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Can't get qualifier for a null class");
        }
        for (DataTypeQualifierEvaluator evaluator : evaluators) {
            DataQualifier qualifier = evaluator.evaluate(clazz);
            if (qualifier == null) continue;
            return qualifier;
        }
        throw new IllegalArgumentException(String.format("Data Qualifier for class %s could not be found.", clazz.getName()));
    }

    private static class PojoTypeQualifierEvaluator
    extends DefaultQualifierEvaluator {
        private PojoTypeQualifierEvaluator() {
            super(Object.class, DataQualifier.POJO);
        }

        @Override
        public boolean isEvaluable(Class<?> c) {
            return !c.isPrimitive();
        }
    }

    private static class EnumDataTypeQualifierEvaluator
    extends DefaultQualifierEvaluator {
        private EnumDataTypeQualifierEvaluator() {
            super(new Class[]{Enumeration.class, Enum.class}, DataQualifier.ENUM);
        }

        @Override
        public boolean isEvaluable(Class<?> c) {
            return c.isEnum() || super.isEvaluable(c);
        }
    }

    private static class DefaultQualifierEvaluator
    implements DataTypeQualifierEvaluator {
        private final Class<?>[] parentClasses;
        private final DataQualifier qualifier;

        private DefaultQualifierEvaluator(Class<?> parentClass, DataQualifier qualifier) {
            this(new Class[]{parentClass}, qualifier);
        }

        private DefaultQualifierEvaluator(Class<?>[] parentClasses, DataQualifier qualifier) {
            this.parentClasses = parentClasses;
            this.qualifier = qualifier;
        }

        @Override
        public DataQualifier evaluate(Class<?> c) {
            if (this.isEvaluable(c)) {
                return this.qualifier;
            }
            return null;
        }

        @Override
        public boolean isEvaluable(Class<?> c) {
            for (Class<?> parentClass : this.parentClasses) {
                if (!parentClass.isAssignableFrom(c)) continue;
                return true;
            }
            return false;
        }
    }

    private static interface DataTypeQualifierEvaluator {
        public boolean isEvaluable(Class<?> var1);

        public DataQualifier evaluate(Class<?> var1);
    }
}

