/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection;

import java.util.Arrays;
import java.util.Objects;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataQualifierFactory;

public final class DataType {
    private final Class<?> type;
    private final DataType[] genericTypes;
    private final DataQualifier qualifier;

    public static DataType of(Class<?> clazz) {
        return DataType.of(clazz, (DataType[])null);
    }

    public static DataType of(Class<?> clazz, Class<?> ... genericTypes) {
        DataType[] types;
        if (genericTypes == null || genericTypes.length == 0) {
            types = new DataType[]{};
        } else {
            types = new DataType[genericTypes.length];
            for (int i = 0; i < genericTypes.length; ++i) {
                types[i] = DataType.of(genericTypes[i]);
            }
        }
        return DataType.of(clazz, types);
    }

    public static DataType of(Class<?> clazz, DataType ... genericTypes) {
        if (genericTypes == null) {
            genericTypes = new DataType[]{};
        }
        return new DataType(clazz, genericTypes, DataQualifierFactory.getQualifier(clazz));
    }

    private DataType(Class<?> type, DataType[] genericTypes, DataQualifier qualifier) {
        if (type == null) {
            throw new IllegalArgumentException("Can't build a DataType for a null type");
        }
        this.type = type;
        this.genericTypes = genericTypes;
        this.qualifier = qualifier;
    }

    public String getName() {
        return this.type.getName();
    }

    public boolean isAssignableFrom(DataType dataType) {
        return this.type.isAssignableFrom(dataType.getRawType());
    }

    public Class<?> getRawType() {
        return this.type;
    }

    public DataType[] getGenericTypes() {
        return this.genericTypes;
    }

    public DataQualifier getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataType) {
            DataType other = (DataType)obj;
            return this.type.equals(other.getRawType()) && Arrays.equals(this.genericTypes, other.getGenericTypes()) && this.qualifier.equals((Object)other.getQualifier());
        }
        return false;
    }

    public int hashCode() {
        int genericTypesHash = Arrays.hashCode(this.genericTypes);
        if (genericTypesHash == 0) {
            genericTypesHash = 1;
        }
        return genericTypesHash * Objects.hash(new Object[]{this.type, this.qualifier}) * 31;
    }
}

