/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.api.registry.SPIServiceRegistry;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.annotations.Configuration;
import org.mule.extension.annotations.Configurations;
import org.mule.extension.annotations.Extension;
import org.mule.extension.annotations.ImplementationOf;
import org.mule.extension.annotations.Operations;
import org.mule.extension.annotations.Parameter;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.introspection.ConfigurationInstantiator;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Describer;
import org.mule.extension.introspection.declaration.ConfigurationConstruct;
import org.mule.extension.introspection.declaration.Construct;
import org.mule.extension.introspection.declaration.DeclarationConstruct;
import org.mule.extension.introspection.declaration.HasCapabilities;
import org.mule.extension.introspection.declaration.OperationConstruct;
import org.mule.extension.introspection.declaration.ParameterConstruct;
import org.mule.extension.introspection.declaration.ParameterDeclaration;
import org.mule.extension.introspection.declaration.WithParameters;
import org.mule.module.extension.internal.capability.metadata.HiddenCapability;
import org.mule.module.extension.internal.capability.metadata.ImplementedTypeCapability;
import org.mule.module.extension.internal.capability.metadata.MemberNameCapability;
import org.mule.module.extension.internal.capability.metadata.ParameterGroupCapability;
import org.mule.module.extension.internal.capability.metadata.TypeRestrictionCapability;
import org.mule.module.extension.internal.introspection.CapabilitiesResolver;
import org.mule.module.extension.internal.introspection.DefaultCapabilitiesResolver;
import org.mule.module.extension.internal.introspection.MuleExtensionAnnotationParser;
import org.mule.module.extension.internal.introspection.ParameterDescriptor;
import org.mule.module.extension.internal.introspection.ParameterGroup;
import org.mule.module.extension.internal.introspection.TypeAwareConfigurationInstantiator;
import org.mule.module.extension.internal.runtime.ReflectiveDelegateFactory;
import org.mule.module.extension.internal.runtime.ReflectiveOperationExecutorFactory;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.Preconditions;

public final class AnnotationsBasedDescriber
implements Describer {
    private CapabilitiesResolver capabilitiesResolver = new DefaultCapabilitiesResolver((ServiceRegistry)new SPIServiceRegistry());
    private final Class<?> extensionType;
    private final ReflectiveDelegateFactory delegateFactory = new ReflectiveDelegateFactory();

    public AnnotationsBasedDescriber(Class<?> extensionType) {
        this.extensionType = extensionType;
    }

    public final Construct describe() {
        Preconditions.checkArgument((this.extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        DeclarationConstruct declaration = this.newDeclarationConstruct(extension);
        this.declareConfigurations(declaration, this.extensionType);
        this.declareOperations(declaration, this.extensionType);
        this.describeCapabilities(declaration, this.extensionType);
        return declaration;
    }

    private DeclarationConstruct newDeclarationConstruct(Extension extension) {
        return new DeclarationConstruct(extension.name(), extension.version()).describedAs(extension.description());
    }

    private void declareConfigurations(DeclarationConstruct declaration, Class<?> extensionType) {
        Configurations configurations = extensionType.getAnnotation(Configurations.class);
        if (configurations != null) {
            for (Class declaringClass : configurations.value()) {
                this.declareConfiguration(declaration, declaringClass);
            }
        } else {
            this.declareConfiguration(declaration, extensionType);
        }
    }

    private void declareConfiguration(DeclarationConstruct declaration, Class<?> extensionType) {
        Preconditions.checkArgument((boolean)CollectionUtils.isEmpty(IntrospectionUtils.getOperationMethods(extensionType)), (String)String.format("Class %s can't declare a configuration and operations at the same time", extensionType.getName()));
        Configuration configurationAnnotation = extensionType.getAnnotation(Configuration.class);
        ConfigurationConstruct configuration = configurationAnnotation != null ? declaration.withConfig(configurationAnnotation.name()).describedAs(configurationAnnotation.description()) : declaration.withConfig("config").describedAs("Default configuration");
        configuration.instantiatedWith((ConfigurationInstantiator)new TypeAwareConfigurationInstantiator(extensionType));
        this.declareConfigurationParameters(extensionType, configuration);
    }

    private void declareConfigurationParameters(Class<?> extensionType, ConfigurationConstruct configuration) {
        this.declareSingleParameters(extensionType, configuration.with());
        List<ParameterGroup> groups = this.declareConfigurationParametersGroups(extensionType, configuration);
        if (!CollectionUtils.isEmpty(groups)) {
            configuration.withCapability((Object)new ParameterGroupCapability(groups));
        }
    }

    private List<ParameterGroup> declareConfigurationParametersGroups(Class<?> extensionType, ConfigurationConstruct configuration) {
        LinkedList<ParameterGroup> groups = new LinkedList<ParameterGroup>();
        for (Field field : IntrospectionUtils.getParameterGroupFields(extensionType)) {
            Set<ParameterConstruct> parameters = this.declareSingleParameters(field.getType(), configuration.with());
            if (parameters.isEmpty()) continue;
            ParameterGroup group = new ParameterGroup(field.getType(), field);
            groups.add(group);
            for (ParameterConstruct construct : parameters) {
                ParameterDeclaration parameter = construct.getDeclaration();
                group.addParameter(parameter.getName(), IntrospectionUtils.getField(field.getType(), MuleExtensionAnnotationParser.getMemberName(parameter, parameter.getName()), parameter.getType().getRawType()));
            }
            List<ParameterGroup> childGroups = this.declareConfigurationParametersGroups(field.getType(), configuration);
            if (CollectionUtils.isEmpty(childGroups)) continue;
            group.addCapability(new ParameterGroupCapability(childGroups));
        }
        return groups;
    }

    private Set<ParameterConstruct> declareSingleParameters(Class<?> extensionType, WithParameters with) {
        ImmutableSet.Builder parameters = ImmutableSet.builder();
        for (Field field : IntrospectionUtils.getParameterFields(extensionType)) {
            Parameter parameter = field.getAnnotation(Parameter.class);
            Optional optional = field.getAnnotation(Optional.class);
            String parameterName = MuleExtensionAnnotationParser.getParameterName(field, parameter);
            DataType dataType = IntrospectionUtils.getFieldDataType(field);
            Object parameterConstruct = optional == null ? with.requiredParameter(parameterName) : with.optionalParameter(parameterName).defaultingTo((Object)MuleExtensionUtils.getDefaultValue(optional));
            parameterConstruct.ofType(dataType);
            if (!parameter.isDynamic()) {
                parameterConstruct.whichIsNotDynamic();
            }
            parameterConstruct.withCapability((Object)new MemberNameCapability(field.getName()));
            parameters.add(parameterConstruct);
        }
        return parameters.build();
    }

    private void declareOperations(DeclarationConstruct declaration, Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        if (operations != null) {
            for (Class actingClass : operations.value()) {
                this.declareOperation(declaration, actingClass);
            }
        } else {
            this.declareOperation(declaration, extensionType);
        }
    }

    private <T> void declareOperation(DeclarationConstruct declaration, Class<T> actingClass) {
        for (Method method : IntrospectionUtils.getOperationMethods(actingClass)) {
            OperationConstruct operation = declaration.withOperation(method.getName()).executorsCreatedBy(new ReflectiveOperationExecutorFactory<T>(actingClass, method, this.delegateFactory));
            this.declareOperationParameters(method, operation);
            this.calculateImplementedTypes(actingClass, method, operation);
        }
    }

    private void calculateImplementedTypes(Class<?> actingClass, Method method, OperationConstruct operation) {
        ImplementationOf implementation = method.getAnnotation(ImplementationOf.class);
        if (implementation == null) {
            implementation = actingClass.getAnnotation(ImplementationOf.class);
        }
        if (implementation != null) {
            operation.withCapability(new ImplementedTypeCapability(implementation.value()));
        }
    }

    private void declareOperationParameters(Method method, OperationConstruct operation) {
        List<ParameterDescriptor> descriptors = MuleExtensionAnnotationParser.parseParameters(method);
        for (ParameterDescriptor parameterDescriptor : descriptors) {
            ParameterConstruct parameter = parameterDescriptor.isRequired() ? operation.with().requiredParameter(parameterDescriptor.getName()) : operation.with().optionalParameter(parameterDescriptor.getName()).defaultingTo(parameterDescriptor.getDefaultValue());
            parameter.describedAs("").ofType(parameterDescriptor.getType());
            this.hideIfNecessary(parameterDescriptor, parameter);
            this.addTypeRestrictions(parameter, parameterDescriptor);
        }
    }

    private void hideIfNecessary(ParameterDescriptor parameterDescriptor, ParameterConstruct parameter) {
        if (parameterDescriptor.isHidden()) {
            parameter.withCapability((Object)new HiddenCapability());
        }
    }

    private void addTypeRestrictions(ParameterConstruct parameter, ParameterDescriptor descriptor) {
        Class<?> restriction = descriptor.getTypeRestriction();
        if (restriction != null) {
            parameter.withCapability(new TypeRestrictionCapability(restriction));
        }
    }

    private void describeCapabilities(DeclarationConstruct declaration, Class<?> extensionType) {
        this.capabilitiesResolver.resolveCapabilities(declaration, extensionType, (HasCapabilities<? extends Construct>)declaration);
    }
}

