/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.api.MuleRuntimeException;
import org.mule.extension.introspection.Configuration;
import org.mule.extension.runtime.ConfigurationInstanceProvider;
import org.mule.extension.runtime.ConfigurationInstanceRegistrationCallback;
import org.mule.extension.runtime.OperationContext;
import org.mule.module.extension.internal.runtime.ConfigurationObjectBuilder;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.module.extension.internal.util.MuleExtensionUtils;

public final class DynamicConfigurationInstanceProvider<T>
implements ConfigurationInstanceProvider<T> {
    private final String name;
    private final Configuration configuration;
    private final ConfigurationObjectBuilder configurationObjectBuilder;
    private final ResolverSet resolverSet;
    private LoadingCache<CacheKey, T> cache;

    public DynamicConfigurationInstanceProvider(String name, Configuration configuration, ConfigurationObjectBuilder configurationObjectBuilder, ResolverSet resolverSet) {
        this.name = name;
        this.configuration = configuration;
        this.configurationObjectBuilder = configurationObjectBuilder;
        this.resolverSet = resolverSet;
        this.buildCache();
    }

    private void buildCache() {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<CacheKey, T>(){

            public T load(CacheKey key) throws Exception {
                Object configurationInstance = DynamicConfigurationInstanceProvider.this.configurationObjectBuilder.build(key.resolverSetResult);
                key.registrationCallback.registerNewConfigurationInstance((ConfigurationInstanceProvider)DynamicConfigurationInstanceProvider.this, configurationInstance);
                return configurationInstance;
            }
        });
    }

    public T get(OperationContext operationContext, ConfigurationInstanceRegistrationCallback registrationCallback) {
        try {
            ResolverSetResult result = this.resolverSet.resolve(MuleExtensionUtils.asOperationContextAdapter(operationContext).getEvent());
            return (T)this.cache.getUnchecked((Object)new CacheKey(result, registrationCallback));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    private static class CacheKey {
        private final ResolverSetResult resolverSetResult;
        private final ConfigurationInstanceRegistrationCallback registrationCallback;

        private CacheKey(ResolverSetResult resolverSetResult, ConfigurationInstanceRegistrationCallback registrationCallback) {
            this.resolverSetResult = resolverSetResult;
            this.registrationCallback = registrationCallback;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                return this.resolverSetResult.equals(((CacheKey)obj).resolverSetResult);
            }
            return false;
        }

        public int hashCode() {
            return this.resolverSetResult.hashCode();
        }
    }
}

