/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.objectweb.asm.Label;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int baseVariableIndex;

    public StackBasedVariableCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        super(methodCompiler, method2, scope, specificArity, argsIndex, firstTempIndex);
        this.baseVariableIndex = firstTempIndex;
    }

    @Override
    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        if (scope.getNumberOfVariables() > 0) {
            if (scope.getRequiredArgs() < scope.getNumberOfVariables()) {
                int start2 = scope.getRequiredArgs();
                this.methodCompiler.loadNil();
                for (int i2 = start2; i2 < scope.getNumberOfVariables(); ++i2) {
                    if (i2 + 1 < scope.getNumberOfVariables()) {
                        this.methodCompiler.method.dup();
                    }
                    this.assignLocalVariable(i2, false);
                }
            }
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void declareLocals(StaticScope scope, Label start2, Label end2) {
        String[] variables = scope.getVariables();
        for (int i2 = 0; i2 < variables.length; ++i2) {
            this.method.local(this.baseVariableIndex + i2, variables[i2], IRubyObject.class);
        }
    }

    @Override
    public void beginClass(StaticScope scope) {
        assert (scope != null) : "compiling a class body with no scope";
        if (scope.getNumberOfVariables() > 0) {
            int start2;
            for (int i2 = start2 = scope.getRequiredArgs(); i2 < scope.getNumberOfVariables(); ++i2) {
                this.methodCompiler.loadNil();
                this.assignLocalVariable(i2, false);
            }
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
    }

    @Override
    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        assert (scope != null) : "compiling a closure body with no scope";
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
        this.method.astore(this.methodCompiler.getDynamicScopeIndex());
        boolean first2 = true;
        for (int i2 = 0; i2 < scope.getNumberOfVariables(); ++i2) {
            if (first2) {
                this.methodCompiler.loadNil();
                first2 = false;
            }
            this.assignLocalVariable(i2, i2 + 1 < scope.getNumberOfVariables());
        }
        this.tempVariableIndex += scope.getNumberOfVariables();
        if (argsCallback != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.methodCompiler.getClosureIndex());
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            this.method.aload(this.argsIndex);
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void beginFlatClosure(CompilerCallback argsCallback, StaticScope scope) {
        throw new NotCompilableException("Can't have flat closure with stack-based scope");
    }

    @Override
    public void assignLocalVariable(int index2, boolean expr) {
        if (expr) {
            this.method.dup();
        }
        this.method.astore(this.baseVariableIndex + index2);
    }

    private void assignLocalVariable(int index2, CompilerCallback value2, boolean expr) {
        value2.call(this.methodCompiler);
        this.assignLocalVariable(index2, expr);
    }

    @Override
    public void assignLocalVariable(int index2, int depth, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, expr);
        } else {
            this.assignHeapLocal(depth, index2, expr);
        }
    }

    @Override
    public void assignLocalVariable(int index2, int depth, CompilerCallback value2, boolean expr) {
        if (depth == 0) {
            this.assignLocalVariable(index2, value2, expr);
        } else {
            this.assignHeapLocal(value2, depth, index2, expr);
        }
    }

    @Override
    public void retrieveLocalVariable(int index2) {
        this.method.aload(this.baseVariableIndex + index2);
    }

    @Override
    public void retrieveLocalVariable(int index2, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index2);
        } else {
            this.retrieveHeapLocal(depth, index2);
        }
    }
}

