/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.security;

import java.util.Map;
import java.util.Properties;
import org.apache.ws.security.WSPasswordCallback;
import org.mule.module.ws.security.AbstractSecurityStrategy;
import org.mule.module.ws.security.SignatureKeyIdentifier;
import org.mule.module.ws.security.WSCryptoUtils;
import org.mule.module.ws.security.WSPasswordCallbackHandler;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextKeyStoreConfiguration;

public class WssSignSecurityStrategy
extends AbstractSecurityStrategy {
    private static final String WS_SIGN_PROPERTIES_KEY = "signProperties";
    private TlsContextFactory tlsContextFactory;
    private SignatureKeyIdentifier signatureKeyIdentifier;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        final TlsContextKeyStoreConfiguration keyStoreConfig = this.tlsContextFactory.getKeyStoreConfiguration();
        this.appendAction(outConfigProperties, "Signature");
        Properties signProperties = WSCryptoUtils.createKeyStoreProperties(keyStoreConfig);
        outConfigProperties.put("signaturePropRefId", WS_SIGN_PROPERTIES_KEY);
        outConfigProperties.put(WS_SIGN_PROPERTIES_KEY, signProperties);
        outConfigProperties.put("signatureUser", keyStoreConfig.getAlias());
        if (this.signatureKeyIdentifier != null) {
            outConfigProperties.put("signatureKeyIdentifier", this.signatureKeyIdentifier.toString());
        }
        this.addPasswordCallbackHandler(outConfigProperties, new WSPasswordCallbackHandler(3){

            @Override
            public void handle(WSPasswordCallback passwordCallback) {
                passwordCallback.setPassword(keyStoreConfig.getKeyPassword());
            }
        });
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public void setSignatureKeyIdentifier(SignatureKeyIdentifier signatureKeyIdentifier) {
        this.signatureKeyIdentifier = signatureKeyIdentifier;
    }
}

