/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.mule.runtime.api.message.MuleMessage;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MediaType;

public interface DataType
extends Serializable {
    public static final DataType TEXT_STRING = DataType.builder().type(String.class).mediaType(MediaType.TEXT).build();
    public static final DataType XML_STRING = DataType.builder().type(String.class).mediaType(MediaType.XML).build();
    public static final DataType JSON_STRING = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_JSON).build();
    public static final DataType HTML_STRING = DataType.builder().type(String.class).mediaType(MediaType.HTML).build();
    public static final DataType ATOM_STRING = DataType.builder().type(String.class).mediaType(MediaType.ATOM).build();
    public static final DataType RSS_STRING = DataType.builder().type(String.class).mediaType(MediaType.RSS).build();
    public static final DataType STRING = DataType.fromType(String.class);
    public static final DataType NUMBER = DataType.fromType(Number.class);
    public static final DataType BOOLEAN = DataType.fromType(Boolean.class);
    public static final DataType OBJECT = DataType.fromType(Object.class);
    public static final DataType BYTE_ARRAY = DataType.fromType(byte[].class);
    public static final DataType INPUT_STREAM = DataType.fromType(InputStream.class);
    public static final DataType MULE_MESSAGE = DataType.builder().type(MuleMessage.class).mediaType(MediaType.ANY).build();
    public static final CollectionDataType MULE_MESSAGE_COLLECTION = (CollectionDataType)AbstractDataTypeBuilderFactory.getDefaultFactory().create().collectionType(Collection.class).itemType(MuleMessage.class).mediaType(MediaType.ANY).build();

    public static DataTypeBuilder builder() {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create();
    }

    public static DataTypeBuilder builder(DataType dataType) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create(dataType);
    }

    public static DataType fromType(Class<?> type) {
        return DataType.builder().type(type).build();
    }

    public static DataType fromObject(Object value) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create().fromObject(value).build();
    }

    public Class<?> getType();

    public MediaType getMediaType();

    public boolean isCompatibleWith(DataType var1);
}

