/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.utils.StringUtils;
import org.mule.runtime.api.metadata.DefaultMetadataKey;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataProperty;

public class MetadataKeyBuilder {
    private final Set<MetadataProperty> properties = new HashSet<MetadataProperty>();
    private final String id;
    private String displayName;
    private Set<MetadataKeyBuilder> childs = new LinkedHashSet<MetadataKeyBuilder>();
    private String partName = "";

    protected MetadataKeyBuilder(String id) {
        this.id = id;
    }

    public static MetadataKeyBuilder newKey(String id) {
        return new MetadataKeyBuilder(id);
    }

    public MetadataKeyBuilder withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MetadataKeyBuilder withProperty(MetadataProperty property) {
        if (this.properties.stream().anyMatch(p -> p.getClass().equals(property.getClass()))) {
            throw new IllegalArgumentException(String.format("The key %s already contains a metadata property of type %s", this.id, property.getClass().getName()));
        }
        this.properties.add(property);
        return this;
    }

    public MetadataKeyBuilder withChild(MetadataKeyBuilder metadataKeyBuilder) {
        this.childs.add(metadataKeyBuilder);
        return this;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    public MetadataKey build() {
        String name = StringUtils.isNotEmpty((String)this.displayName) ? this.displayName : this.id;
        return new DefaultMetadataKey(this.id, name, this.properties, this.childs.stream().map(MetadataKeyBuilder::build).collect(Collectors.toSet()), this.partName);
    }
}

