/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor.builder;

import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ImmutableParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;

public class ParameterMetadataDescriptorBuilder {
    private final String name;
    private MetadataType type;

    ParameterMetadataDescriptorBuilder(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name parameter cannot be blank for TypeMetadataDescriptor");
        }
        this.name = name;
    }

    public ParameterMetadataDescriptorBuilder withType(MetadataType type) {
        this.type = type;
        return this;
    }

    public ParameterMetadataDescriptor build() {
        if (this.type == null) {
            throw new IllegalArgumentException("Type parameter cannot be null for ParameterMetadataDescriptor");
        }
        return new ImmutableParameterMetadataDescriptor(this.name, this.type);
    }
}

