/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.resolving;

import java.util.Optional;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.ImmutableMetadataResult;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

public interface MetadataResult<T> {
    public static <T> MetadataResult<T> success(T payload) {
        return new ImmutableMetadataResult<T>(payload);
    }

    public static <T> MetadataResult<T> failure(Exception e) {
        return new ImmutableMetadataResult(e);
    }

    public static <T> MetadataResult<T> failure(T newPayload, MetadataResult<?> originalResult) {
        if (!originalResult.getFailure().isPresent()) {
            throw new IllegalArgumentException("A failing result was expected but no Failures were found");
        }
        return new ImmutableMetadataResult<T>(newPayload, originalResult.getFailure().get());
    }

    public static <T> MetadataResult<T> failure(T payload, Exception e) {
        return new ImmutableMetadataResult<T>(payload, e);
    }

    public static <T> MetadataResult<T> failure(T payload, String message, Exception e) {
        return new ImmutableMetadataResult<T>(payload, message, e);
    }

    public static <T> MetadataResult<T> failure(T payload, String message, FailureCode failure, String reason) {
        return new ImmutableMetadataResult<T>(payload, new MetadataFailure(message, reason, failure));
    }

    public T get();

    public boolean isSuccess();

    public Optional<MetadataFailure> getFailure();
}

