/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.debug;

import org.mule.util.Preconditions;
import org.mule.util.StringUtils;

public abstract class FieldDebugInfo<T> {
    private final String name;
    private final String type;
    private final T value;

    FieldDebugInfo(String name, String type, T value) {
        Preconditions.checkArgument(!StringUtils.isEmpty((String)name), "Name cannot be empty");
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.format("%s[name: '%s', type: '%s', value: '%s']", this.getClass().getSimpleName(), this.getName(), this.type, this.getValue());
    }
}

