/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.lifecycle;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.slf4j.Logger;

public class LifecycleUtils {
    private LifecycleUtils() {
    }

    public static void initialiseIfNeeded(Object object) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(object, null);
    }

    public static void initialiseIfNeeded(Object object, MuleContext muleContext) throws InitialisationException {
        if (muleContext != null && object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(muleContext);
        }
        if (object instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects) throws InitialisationException {
        try {
            LifecycleUtils.doApplyPhase("initialise", objects, null);
        }
        catch (MuleException e) {
            throw (InitialisationException)e;
        }
    }

    public static void startIfNeeded(Object object) throws MuleException {
        if (object instanceof Startable) {
            ((Startable)object).start();
        }
    }

    public static void startIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("start", objects, null);
    }

    public static void stopIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("stop", objects, null);
    }

    public static void stopIfNeeded(Object object) throws MuleException {
        LifecycleUtils.doApplyPhase("stop", Arrays.asList(object), null);
    }

    public static void disposeIfNeeded(Object object, Logger logger) {
        LifecycleUtils.disposeAllIfNeeded(Arrays.asList(object), logger);
    }

    public static void disposeAllIfNeeded(Collection<? extends Object> objects, Logger logger) {
        try {
            LifecycleUtils.doApplyPhase("dispose", objects, logger);
        }
        catch (MuleException e) {
            logger.error("Exception found trying to dispose object. Shutdown will continue", (Throwable)e);
        }
    }

    private static void doApplyPhase(String phase, Collection<? extends Object> objects, Logger logger) throws MuleException {
        if (CollectionUtils.isEmpty(objects)) {
            return;
        }
        for (Object object : objects) {
            if (object == null) continue;
            try {
                if ("initialise".equals(phase) && object instanceof Initialisable) {
                    ((Initialisable)object).initialise();
                    continue;
                }
                if ("start".equals(phase) && object instanceof Startable) {
                    ((Startable)object).start();
                    continue;
                }
                if ("stop".equals(phase) && object instanceof Stoppable) {
                    ((Stoppable)object).stop();
                    continue;
                }
                if (!"dispose".equals(phase) || !(object instanceof Disposable)) continue;
                ((Disposable)object).dispose();
            }
            catch (MuleException e) {
                if (logger != null) {
                    logger.error(String.format("Could not apply phase %s on object of class %s", phase, object.getClass().getName()), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }
}

