/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Transformer;
import org.mule.config.bootstrap.ArtifactType;
import org.mule.config.bootstrap.BootstrapException;
import org.mule.config.bootstrap.ClassPathRegistryBootstrapDiscoverer;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.OrderedProperties;
import org.mule.util.PropertiesUtils;
import org.mule.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryBootstrap
implements Initialisable,
MuleContextAware {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TRANSFORMER_KEY = ".transformer.";
    public static final String OBJECT_KEY = ".object.";
    public static final String SINGLE_TX = ".singletx.";
    protected ArtifactType supportedArtifactType = ArtifactType.APP;
    protected final RegistryBootstrapDiscoverer discoverer;
    protected MuleContext muleContext;

    public AbstractRegistryBootstrap() {
        this(new ClassPathRegistryBootstrapDiscoverer());
    }

    public AbstractRegistryBootstrap(RegistryBootstrapDiscoverer discoverer) {
        this.discoverer = discoverer;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        List<Properties> bootstraps;
        try {
            bootstraps = this.discoverer.discover();
        }
        catch (BootstrapException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        int objectCounter = 1;
        int transformerCounter = 1;
        OrderedProperties transformers = new OrderedProperties();
        OrderedProperties namedObjects = new OrderedProperties();
        OrderedProperties unnamedObjects = new OrderedProperties();
        LinkedHashMap<String, String> singleTransactionFactories = new LinkedHashMap<String, String>();
        for (Properties bootstrap : bootstraps) {
            for (Map.Entry<Object, Object> entry : bootstrap.entrySet()) {
                String newKey;
                String key = (String)entry.getKey();
                if (key.contains(OBJECT_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + objectCounter++;
                    ((Properties)unnamedObjects).put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(TRANSFORMER_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + transformerCounter++;
                    ((Properties)transformers).put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(SINGLE_TX)) {
                    if (key.contains(".transaction.resource")) continue;
                    String transactionResourceKey = key.replace(".transaction.factory", ".transaction.resource");
                    String transactionResource = bootstrap.getProperty(transactionResourceKey);
                    if (transactionResource == null) {
                        throw new InitialisationException(CoreMessages.createStaticMessage(String.format("Theres no transaction resource specified for transaction factory %s", key)), (Initialisable)this);
                    }
                    singleTransactionFactories.put((String)entry.getValue(), transactionResource);
                    continue;
                }
                ((Properties)namedObjects).put(key, entry.getValue());
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects);
            this.registerTransformers();
            this.registerTransformers(transformers);
            this.registerObjects(namedObjects);
            this.registerTransactionFactories(singleTransactionFactories, this.muleContext);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private void registerUnnamedObjects(Properties props) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.format("%s#%s", entry.getKey(), UUID.getUUID());
            this.registerObject(key, (String)entry.getValue());
        }
        props.clear();
    }

    private void registerObjects(Properties props) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.registerObject((String)entry.getKey(), (String)entry.getValue());
        }
        props.clear();
    }

    private void registerObject(String key, String value) throws Exception {
        ArtifactType artifactTypeParameterValue = ArtifactType.APP;
        boolean optional = false;
        String className = null;
        try {
            int x = value.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(value.substring(x + 1), ',');
                if (p.containsKey("applyToArtifactType")) {
                    artifactTypeParameterValue = ArtifactType.createFromString((String)p.get("applyToArtifactType"));
                }
                optional = p.containsKey("optional");
                className = value.substring(0, x);
            } else {
                className = value;
            }
            if (!artifactTypeParameterValue.equals((Object)ArtifactType.ALL) && !artifactTypeParameterValue.equals((Object)this.supportedArtifactType)) {
                return;
            }
            this.doRegisterObject(key, className, optional);
        }
        catch (InvocationTargetException itex) {
            Throwable cause = ExceptionUtils.getCause((Throwable)itex);
            this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && optional, cause, "Ignoring optional object: " + className);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional object: " + className);
        }
        catch (ClassNotFoundException cnfe) {
            this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional object: " + className);
        }
        catch (NoSuchMethodException nsme) {
            this.throwExceptionIfNotOptional(optional, nsme, "Ignoring optional object: " + className);
        }
    }

    private void registerTransactionFactories(Map<String, String> singleTransactionFactories, MuleContext context) throws Exception {
        for (Map.Entry<String, String> entry : singleTransactionFactories.entrySet()) {
            String transactionResourceClassNameProperties = entry.getValue();
            String transactionFactoryClassName = entry.getKey();
            boolean optional = false;
            int x = transactionResourceClassNameProperties.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transactionResourceClassNameProperties.substring(x + 1), ',');
                optional = p.containsKey("optional");
            }
            String transactionResourceClassName = x == -1 ? transactionResourceClassNameProperties : transactionResourceClassNameProperties.substring(0, x);
            try {
                context.getTransactionFactoryManager().registerTransactionFactory(Class.forName(transactionResourceClassName), (TransactionFactory)Class.forName(transactionFactoryClassName).newInstance());
            }
            catch (NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional transaction factory: " + transactionResourceClassName);
            }
            catch (ClassNotFoundException cnfe) {
                this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional transaction factory: " + transactionResourceClassName);
            }
        }
    }

    private void registerTransformers(Properties props) throws Exception {
        String name = null;
        boolean optional = false;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String transString = (String)entry.getValue();
            Class returnClass = null;
            String returnClassString = null;
            int x = transString.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(x + 1), ',');
                name = p.getProperty("name", null);
                returnClassString = p.getProperty("returnClass", null);
                optional = p.containsKey("optional");
            }
            Class transformerClass = this.getClass(x == -1 ? transString : transString.substring(0, x));
            try {
                String mime = null;
                if (returnClassString != null) {
                    int i = returnClassString.indexOf(":");
                    if (i > -1) {
                        mime = returnClassString.substring(i + 1);
                        returnClassString = returnClassString.substring(0, i);
                    }
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : ClassUtils.loadClass(returnClassString, this.getClass());
                }
                this.doRegisterTransformer(name, returnClass, transformerClass, mime, optional);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && optional, cause, "Ignoring optional transformer: " + transformerClass.getClass().getName());
            }
            catch (NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional transformer: " + transformerClass.getClass().getName());
            }
            catch (ClassNotFoundException cnfe) {
                this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional transformer: " + transformerClass.getClass().getName());
            }
            name = null;
        }
    }

    protected abstract void doRegisterTransformer(String var1, Class<?> var2, Class<? extends Transformer> var3, String var4, boolean var5) throws Exception;

    protected Class getClass(String className) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, this.getClass());
    }

    protected abstract void registerTransformers() throws MuleException;

    protected abstract void doRegisterObject(String var1, String var2, boolean var3) throws Exception;

    private void throwExceptionIfNotOptional(boolean optional, Throwable t, String message) throws Exception {
        if (optional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(message);
            }
        } else {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    public void setSupportedArtifactType(ArtifactType supportedArtifactType) {
        this.supportedArtifactType = supportedArtifactType;
    }
}

