/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.execution.ExceptionContextProvider;
import org.mule.api.processor.MessageProcessor;
import org.mule.execution.MessageProcessorExecutionInterceptor;

public class ExceptionToMessagingExceptionExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    @Override
    public MuleEvent execute(MessageProcessor messageProcessor, MuleEvent event) throws MessagingException {
        try {
            return messageProcessor.process(event);
        }
        catch (MessagingException messagingException) {
            if (messagingException.getFailingMessageProcessor() == null) {
                throw this.putContext(messagingException, messageProcessor, event);
            }
            throw this.putContext(messagingException, messagingException.getFailingMessageProcessor(), event);
        }
        catch (Throwable ex) {
            throw this.putContext(new MessagingException(event, ex, messageProcessor), messageProcessor, event);
        }
    }

    private MessagingException putContext(MessagingException messagingException, MessageProcessor failingMessageProcessor, MuleEvent event) {
        for (ExceptionContextProvider exceptionContextProvider : event.getMuleContext().getExceptionContextProviders()) {
            for (Map.Entry<String, Object> contextInfoEntry : exceptionContextProvider.getContextInfo(event, failingMessageProcessor).entrySet()) {
                if (messagingException.getInfo().containsKey(contextInfoEntry.getKey())) continue;
                messagingException.getInfo().put(contextInfoEntry.getKey(), contextInfoEntry.getValue());
            }
        }
        return messagingException;
    }
}

