/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.List;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.execution.EndPhaseTemplate;
import org.mule.execution.EndProcessPhase;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.PhaseResultNotifier;

public class PhaseExecutionEngine {
    private final List<MessageProcessPhase> phaseList;
    private final SystemExceptionHandler exceptionHandler;
    private final EndProcessPhase endProcessPhase;

    public PhaseExecutionEngine(List<MessageProcessPhase> messageProcessPhaseList, SystemExceptionHandler exceptionHandler, EndProcessPhase endProcessPhase) {
        this.phaseList = messageProcessPhaseList;
        this.exceptionHandler = exceptionHandler;
        this.endProcessPhase = endProcessPhase;
    }

    public void process(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        InternalPhaseExecutionEngine internalPhaseExecutionEngine = new InternalPhaseExecutionEngine(messageProcessTemplate, messageProcessContext);
        internalPhaseExecutionEngine.process();
    }

    public class InternalPhaseExecutionEngine
    implements PhaseResultNotifier {
        private int currentPhase = 0;
        private final MessageProcessContext messageProcessContext;
        private final MessageProcessTemplate messageProcessTemplate;
        private boolean endPhaseProcessed;

        public InternalPhaseExecutionEngine(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
            this.messageProcessTemplate = messageProcessTemplate;
            this.messageProcessContext = messageProcessContext;
        }

        @Override
        public void phaseSuccessfully() {
            ++this.currentPhase;
            if (this.currentPhase < PhaseExecutionEngine.this.phaseList.size()) {
                if (((MessageProcessPhase)PhaseExecutionEngine.this.phaseList.get(this.currentPhase)).supportsTemplate(this.messageProcessTemplate)) {
                    ((MessageProcessPhase)PhaseExecutionEngine.this.phaseList.get(this.currentPhase)).runPhase(this.messageProcessTemplate, this.messageProcessContext, this);
                } else {
                    this.phaseSuccessfully();
                }
            } else {
                this.processEndPhase();
            }
        }

        @Override
        public void phaseConsumedMessage() {
            this.processEndPhase();
        }

        @Override
        public void phaseFailure(Exception reason) {
            PhaseExecutionEngine.this.exceptionHandler.handleException(reason);
            this.processEndPhase();
        }

        private void processEndPhase() {
            if (!this.endPhaseProcessed) {
                this.endPhaseProcessed = true;
                if (PhaseExecutionEngine.this.endProcessPhase.supportsTemplate(this.messageProcessTemplate)) {
                    PhaseExecutionEngine.this.endProcessPhase.runPhase((EndPhaseTemplate)this.messageProcessTemplate, this.messageProcessContext, (PhaseResultNotifier)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            ClassLoader originalClassLoader = null;
            try {
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.messageProcessContext.getExecutionClassLoader());
                for (MessageProcessPhase phase : PhaseExecutionEngine.this.phaseList) {
                    if (phase.supportsTemplate(this.messageProcessTemplate)) {
                        phase.runPhase(this.messageProcessTemplate, this.messageProcessContext, this);
                        return;
                    }
                    ++this.currentPhase;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }
}

