/*
 * Decompiled with CFR 0.152.
 */
package org.mule.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.security.MessageDigest;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventKeyGenerator;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256MuleEventKeyGenerator
implements MuleEventKeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SHA256MuleEventKeyGenerator.class);

    @Override
    public Serializable generateKey(MuleEvent event) throws NotSerializableException {
        try {
            byte[] bytesOfMessage = event.getMessageAsBytes();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String key = StringUtils.toHexString(md.digest(bytesOfMessage));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Generated key for event: %s key: %s", event, key));
            }
            return key;
        }
        catch (Exception e) {
            NotSerializableException notSerializableException = new NotSerializableException(e.getMessage());
            notSerializableException.initCause(e);
            throw notSerializableException;
        }
    }
}

