/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mule.api.agent.Agent;
import org.mule.api.component.Component;
import org.mule.api.config.Config;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.model.Model;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.LifecycleObject;
import org.mule.lifecycle.NotificationLifecycleObject;
import org.mule.lifecycle.phases.DefaultLifecyclePhase;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class MuleContextInitialisePhase
extends DefaultLifecyclePhase {
    public MuleContextInitialisePhase() {
        super("initialise", Initialisable.class, "dispose");
        this.registerSupportedPhase("not in lifecycle");
        LinkedHashSet<LifecycleObject> startOrderedObjects = new LinkedHashSet<LifecycleObject>();
        startOrderedObjects.add(new NotificationLifecycleObject(Config.class));
        startOrderedObjects.add(new NotificationLifecycleObject(Connector.class));
        startOrderedObjects.add(new NotificationLifecycleObject(Agent.class));
        startOrderedObjects.add(new NotificationLifecycleObject(Model.class));
        startOrderedObjects.add(new NotificationLifecycleObject(FlowConstruct.class));
        startOrderedObjects.add(new NotificationLifecycleObject(Initialisable.class));
        this.setOrderedLifecycleObjects(startOrderedObjects);
        this.setIgnoredObjectTypes(new Class[]{Component.class, MessageSource.class, OutboundRouterCollection.class, OutboundRouter.class});
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        super.applyLifecycle(o);
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(o.getClass(), PostConstruct.class);
        if (annos.size() == 1) {
            AnnotationMetaData anno = annos.get(0);
            try {
                ((Method)anno.getMember()).invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(anno.getMember().getName(), o), e, this);
            }
        }
    }
}

