/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.AbstractAnnotatedObject;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.RequestContext;
import org.mule.api.CompletionHandler;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.transport.ReplyToHandler;
import org.mule.construct.Flow;
import org.mule.processor.NonBlockingMessageProcessor;

public abstract class AbstractNonBlockingMessageProcessor
extends AbstractAnnotatedObject
implements NonBlockingMessageProcessor,
MessagingExceptionHandlerAware {
    private MessagingExceptionHandler messagingExceptionHandler;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isNonBlocking(event)) {
            this.processNonBlocking(event, this.createNonBlockingCompletionHandler(event));
            RequestContext.clear();
            return NonBlockingVoidMuleEvent.getInstance();
        }
        return this.processBlocking(event);
    }

    protected boolean isNonBlocking(MuleEvent event) {
        return event.getFlowConstruct() instanceof Flow && event.isAllowNonBlocking() && event.getReplyToHandler() != null;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    protected abstract void processNonBlocking(MuleEvent var1, CompletionHandler var2) throws MuleException;

    protected abstract MuleEvent processBlocking(MuleEvent var1) throws MuleException;

    private NonBlockingCompletionHandler createNonBlockingCompletionHandler(MuleEvent event) {
        return new NonBlockingCompletionHandler(event);
    }

    class NonBlockingCompletionHandler
    implements CompletionHandler<MuleEvent, MessagingException> {
        private final MuleEvent event;
        private final ReplyToHandler replyToHandler;

        NonBlockingCompletionHandler(MuleEvent event) {
            this.event = event;
            this.replyToHandler = event.getReplyToHandler();
        }

        @Override
        public void onFailure(MessagingException exception) {
            this.replyToHandler.processExceptionReplyTo(exception, null);
        }

        @Override
        public void onCompletion(MuleEvent event) {
            try {
                this.replyToHandler.processReplyTo(event, null, null);
            }
            catch (Exception e) {
                AbstractNonBlockingMessageProcessor.this.messagingExceptionHandler.handleException(e, event);
            }
        }
    }
}

