/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.model.SessionException;
import org.mule.config.i18n.MessageFactory;
import org.mule.session.SerializeOnlySessionHandler;
import org.mule.util.Base64;

public class SerializeAndEncodeSessionHandler
extends SerializeOnlySessionHandler {
    @Override
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        byte[] serializedSession;
        MuleSession session = null;
        String serializedEncodedSession = (String)message.getInboundProperty("MULE_SESSION");
        if (serializedEncodedSession != null && (serializedSession = Base64.decodeWithoutUnzipping(serializedEncodedSession)) != null) {
            session = (MuleSession)this.deserialize(message, serializedSession);
        }
        return session;
    }

    @Override
    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        String serializedEncodedSession;
        session = this.removeNonSerializableProperties(session, message.getMuleContext());
        byte[] serializedSession = this.serialize(message, session);
        try {
            serializedEncodedSession = Base64.encodeBytes(serializedSession, 8);
        }
        catch (IOException e) {
            throw new SessionException(MessageFactory.createStaticMessage("Unable to serialize MuleSession"), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized and base64-encoded Session header to message: " + serializedEncodedSession));
        }
        message.setOutboundProperty("MULE_SESSION", serializedEncodedSession);
    }
}

