/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.mule.api.MuleException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.streaming.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListableObjectStoreProducer<T extends Serializable>
implements Producer<T> {
    private static final Logger logger = LoggerFactory.getLogger(ListableObjectStoreProducer.class);
    private ListableObjectStore<T> objectStore;
    private Iterator<Serializable> keys;
    private int size;

    public ListableObjectStoreProducer(ListableObjectStore<T> objectStore) {
        if (objectStore == null) {
            throw new IllegalArgumentException("Cannot construct a producer with a null object store");
        }
        this.objectStore = objectStore;
        try {
            ArrayList<Serializable> allKeys = new ArrayList<Serializable>(objectStore.allKeys());
            this.keys = allKeys.iterator();
            this.size = allKeys.size();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Could not construct producer because exception was found retrieving keys", e);
        }
    }

    @Override
    public T produce() {
        if (this.objectStore == null || !this.keys.hasNext()) {
            return null;
        }
        Serializable key = this.keys.next();
        try {
            return this.objectStore.retrieve(key);
        }
        catch (ObjectDoesNotExistException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("key %s no longer available in objectstore. This is likely due to a concurrency issue. Will continue with next key if available", key));
            }
            return (T)this.produce();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void close() throws MuleException {
        this.objectStore = null;
        this.keys = null;
    }
}

