/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.api.MuleEvent;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.polling.MessageProcessorPollingOverride;
import org.mule.transport.polling.watermark.WatermarkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Watermark
extends MessageProcessorPollingOverride {
    private static final Logger logger = LoggerFactory.getLogger(Watermark.class);
    private final String variable;
    private final String defaultExpression;
    private final ObjectStore<Serializable> objectStore;
    protected Map<QName, Object> annotations = new HashMap<QName, Object>();

    public Watermark(ObjectStore<Serializable> objectStore, String variable, String defaultExpression) {
        this.objectStore = objectStore;
        this.variable = variable;
        this.defaultExpression = defaultExpression;
    }

    protected String resolveVariable(MuleEvent event) {
        try {
            return WatermarkUtils.evaluate(this.variable, event).toString();
        }
        catch (NotSerializableException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void putInto(MuleEvent event) throws ObjectStoreException {
        String resolvedVariable = this.resolveVariable(event);
        Serializable watermarkValue = null;
        try {
            watermarkValue = this.objectStore.retrieve((Serializable)((Object)resolvedVariable));
        }
        catch (ObjectDoesNotExistException ex) {
            try {
                watermarkValue = WatermarkUtils.evaluate(this.defaultExpression, event);
            }
            catch (NotSerializableException nse) {
                logger.warn(String.format("Default watermark expression '%s' returned not serializable value", this.defaultExpression), (Throwable)nse);
            }
        }
        if (watermarkValue != null) {
            event.setFlowVariable(resolvedVariable, watermarkValue);
        } else {
            logger.warn(CoreMessages.nullWatermark().getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateWith(MuleEvent event, Serializable newValue) throws ObjectStoreException {
        if (!this.validateNewWatermarkValue(newValue)) {
            return;
        }
        String variableName = this.resolveVariable(event);
        ObjectStore<Serializable> objectStore = this.objectStore;
        synchronized (objectStore) {
            if (this.objectStore.contains((Serializable)((Object)variableName))) {
                this.objectStore.remove((Serializable)((Object)variableName));
            }
            if (newValue != null) {
                this.objectStore.store((Serializable)((Object)variableName), newValue);
            }
        }
    }

    public final void updateFrom(MuleEvent event) throws ObjectStoreException {
        try {
            Object watermarkValue = this.getUpdatedValue(event);
            this.validateNewWatermarkValue(watermarkValue);
            if (!(watermarkValue instanceof Serializable)) {
                throw new IllegalArgumentException(CoreMessages.notSerializableWatermark(this.resolveVariable(event)).getMessage());
            }
            this.updateWith(event, (Serializable)watermarkValue);
        }
        catch (Exception e) {
            logger.error("Exception found updating watermark", (Throwable)e);
        }
    }

    protected abstract Object getUpdatedValue(MuleEvent var1);

    private boolean validateNewWatermarkValue(Object value) {
        if (value == null) {
            if (logger.isInfoEnabled()) {
                logger.info(CoreMessages.nullWatermark().getMessage());
            }
            return false;
        }
        return true;
    }
}

