/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.polling.MessageProcessorPollingInterceptor;
import org.mule.transport.polling.watermark.Watermark;

public class WatermarkPollingInterceptor
extends MessageProcessorPollingInterceptor {
    protected final Watermark watermark;

    public WatermarkPollingInterceptor(Watermark watermark) {
        this.watermark = watermark;
    }

    @Override
    public MuleEvent prepareSourceEvent(MuleEvent event) throws MuleException {
        this.watermark.putInto(event);
        return event;
    }

    @Override
    public MuleEvent prepareRouting(MuleEvent sourceEvent, MuleEvent event) throws ConfigurationException {
        if (!event.isSynchronous()) {
            throw new ConfigurationException(CoreMessages.watermarkRequiresSynchronousProcessing());
        }
        String variableName = this.watermark.resolveVariable(event);
        event.setFlowVariable(variableName, sourceEvent.getFlowVariable(variableName));
        return event;
    }

    @Override
    public void postProcessRouting(MuleEvent event) throws ObjectStoreException {
        this.watermark.updateFrom(event);
    }
}

