/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.registry.ServiceType;
import org.mule.config.ExceptionHelper;
import org.mule.transport.service.TransportFactory;
import org.mule.util.IOUtils;

public class SpiUtils {
    private static final Log logger = LogFactory.getLog(SpiUtils.class);
    public static final String SERVICE_ROOT = "META-INF/services/";

    public static Properties findServiceDescriptor(ServiceType type, String name) {
        if (type.equals((Object)ServiceType.TRANSPORT)) {
            Properties tsd = SpiUtils.findServiceDescriptor(type.getPath(), name, TransportFactory.class, false);
            if (tsd == null) {
                tsd = SpiUtils.findServiceDescriptor(type.getPath(), name, TransportFactory.class);
            }
            return tsd;
        }
        if (type.equals((Object)ServiceType.EXCEPTION)) {
            return SpiUtils.findServiceDescriptor(type.getPath(), name, ExceptionHelper.class);
        }
        logger.warn((Object)("Attempt to lookup unrecognized service type: " + (Object)((Object)type)));
        return null;
    }

    public static Properties findServiceDescriptor(String path, String name, Class currentClass) {
        return SpiUtils.findServiceDescriptor(path, name, currentClass, true);
    }

    public static Properties findServiceDescriptor(String path, String name, Class currentClass, boolean fallbackToNonPreferred) {
        String preferredName = null;
        String preferredPath = null;
        if (!name.endsWith(".properties")) {
            name = name + ".properties";
            preferredName = "preferred-" + name;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (path.startsWith(SERVICE_ROOT)) {
            path = path + name;
        } else {
            preferredPath = SERVICE_ROOT + path + preferredName;
            path = SERVICE_ROOT + path + name;
        }
        try {
            InputStream is = IOUtils.getResourceAsStream(preferredPath, currentClass, false, false);
            if (is == null && fallbackToNonPreferred) {
                is = IOUtils.getResourceAsStream(path, currentClass, false, false);
            }
            if (is != null) {
                Properties props = new Properties();
                try {
                    props.load(is);
                    return props;
                }
                catch (IOException e) {
                    logger.warn((Object)("Descriptor found but unable to load properties for service " + name));
                    return null;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties findServiceDescriptors(String path, String name, Class currentClass) {
        if (!name.endsWith(".properties")) {
            name = name + ".properties";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path.startsWith(SERVICE_ROOT) ? path + name : SERVICE_ROOT + path + name;
        try {
            Properties props = new Properties();
            Enumeration<URL> urls = currentClass.getClassLoader().getResources(path);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream inputStream = null;
                try {
                    inputStream = url.openStream();
                    props.load(inputStream);
                }
                catch (IOException e) {
                    logger.warn((Object)("Descriptor found but unable to load properties for service " + name));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            return props;
        }
        catch (IOException e) {
            return null;
        }
    }
}

