/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.concurrent.DaemonThreadFactory;
import org.mule.util.monitor.Expirable;

public class ExpiryMonitor
implements Runnable,
Disposable {
    protected static final Log logger = LogFactory.getLog(ExpiryMonitor.class);
    protected ScheduledThreadPoolExecutor scheduler;
    private Map monitors;
    private int monitorFrequency;
    private String name;
    private ClassLoader contextClassLoader;
    private MuleContext muleContext;
    private boolean onPollingNodeOnly;

    public ExpiryMonitor(MuleContext muleContext, boolean onPollingNodeOnly) {
        this.muleContext = muleContext;
        this.onPollingNodeOnly = onPollingNodeOnly;
    }

    public ExpiryMonitor(String name, MuleContext muleContext, boolean onPollingNodeOnly) {
        this(name, 1000, muleContext, onPollingNodeOnly);
    }

    public ExpiryMonitor(String name, int monitorFrequency, MuleContext muleContext, boolean onPollingNodeOnly) {
        this(muleContext, onPollingNodeOnly);
        this.name = name;
        this.monitorFrequency = monitorFrequency;
        this.init();
    }

    public ExpiryMonitor(String name, int monitorFrequency, ClassLoader contextClassLoader, MuleContext muleContext, boolean onPollingNodeOnly) {
        this(muleContext, onPollingNodeOnly);
        this.name = name;
        this.monitorFrequency = monitorFrequency;
        this.contextClassLoader = contextClassLoader;
        this.init();
    }

    public ExpiryMonitor(String name, int monitorFrequency, ScheduledThreadPoolExecutor scheduler, MuleContext muleContext, boolean onPollingNodeOnly) {
        this(muleContext, onPollingNodeOnly);
        this.name = name;
        this.monitorFrequency = monitorFrequency;
        this.scheduler = scheduler;
        this.init();
    }

    protected void init() {
        if (this.monitorFrequency <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("monitorFrequency", new Integer(this.monitorFrequency)).toString());
        }
        this.monitors = new ConcurrentHashMap();
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setThreadFactory(new DaemonThreadFactory(this.name + ".expiry.monitor", this.contextClassLoader));
            this.scheduler.scheduleWithFixedDelay(this, 0L, this.monitorFrequency, TimeUnit.MILLISECONDS);
        }
    }

    public void addExpirable(long value, TimeUnit timeUnit, Expirable expirable) {
        if (this.isRegistered(expirable)) {
            this.resetExpirable(expirable);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding new expirable: " + expirable));
            }
            this.monitors.put(expirable, new ExpirableHolder(timeUnit.toMillis(value), expirable));
        }
    }

    public boolean isRegistered(Expirable expirable) {
        return this.monitors.get(expirable) != null;
    }

    public void removeExpirable(Expirable expirable) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing expirable: " + expirable));
        }
        this.monitors.remove(expirable);
    }

    public void resetExpirable(Expirable expirable) {
        ExpirableHolder eh = (ExpirableHolder)this.monitors.get(expirable);
        if (eh != null) {
            eh.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reset expirable: " + expirable));
            }
        }
    }

    @Override
    public void run() {
        if (!this.onPollingNodeOnly || this.muleContext == null || this.muleContext.isPrimaryPollingInstance()) {
            for (ExpirableHolder holder : this.monitors.values()) {
                if (!holder.isExpired()) continue;
                this.removeExpirable(holder.getExpirable());
                holder.getExpirable().expired();
            }
        }
    }

    @Override
    public void dispose() {
        logger.info((Object)"disposing monitor");
        this.scheduler.shutdown();
        for (ExpirableHolder holder : this.monitors.values()) {
            this.removeExpirable(holder.getExpirable());
            try {
                holder.getExpirable().expired();
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
            }
        }
    }

    private static class ExpirableHolder {
        private Expirable expirable;
        private long milliseconds;
        private long created;

        public ExpirableHolder(long milliseconds, Expirable expirable) {
            this.milliseconds = milliseconds;
            this.expirable = expirable;
            this.created = System.currentTimeMillis();
        }

        public long getMilliSeconds() {
            return this.milliseconds;
        }

        public Expirable getExpirable() {
            return this.expirable;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.milliseconds > this.created;
        }

        public void reset() {
            this.created = System.currentTimeMillis();
        }
    }
}

