/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import com.google.common.hash.HashCode;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class MuleXid
implements Xid,
Comparable<Xid> {
    private final int formatId;
    private final byte[] globalTransactionId;
    private final byte[] branchQualifier;

    public MuleXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    public MuleXid(Xid txId) {
        this.formatId = txId.getFormatId();
        this.globalTransactionId = txId.getGlobalTransactionId();
        this.branchQualifier = txId.getBranchQualifier();
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)obj;
        return Arrays.equals(this.getGlobalTransactionId(), other.getGlobalTransactionId()) && Arrays.equals(this.getBranchQualifier(), other.getBranchQualifier()) && this.getFormatId() == other.getFormatId();
    }

    public int hashCode() {
        return this.formatId * HashCode.fromBytes((byte[])this.globalTransactionId).asInt() * HashCode.fromBytes((byte[])this.branchQualifier).asInt() * 17;
    }

    @Override
    public int compareTo(Xid o) {
        if (this.formatId == o.getFormatId() && Arrays.equals(this.globalTransactionId, o.getGlobalTransactionId()) && Arrays.equals(this.branchQualifier, o.getBranchQualifier())) {
            return 0;
        }
        return this.hashCode() > o.hashCode() ? 1 : -1;
    }
}

