/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultExceptionStrategyTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testExceptions() throws Exception {
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy(muleContext);
        strategy.setMuleContext(muleContext);
        strategy.handleException(new IllegalArgumentException("boom"));
        Assert.assertEquals((long)1L, (long)strategy.getCount());
    }

    @Test
    public void testExceptionNotifications() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger notificationCount = new AtomicInteger(0);
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                if (notification.getAction() == 1101) {
                    Assert.assertEquals((Object)"exception", (Object)notification.getActionName());
                    Assert.assertEquals((String)"Wrong info type", (Object)"error", (Object)notification.getType());
                    notificationCount.incrementAndGet();
                    latch.countDown();
                }
            }
        });
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy(muleContext);
        strategy.setMuleContext(muleContext);
        strategy.handleException(new IllegalArgumentException("boom"));
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)notificationCount.get());
    }

    private static class InstrumentedExceptionStrategy
    extends DefaultSystemExceptionStrategy {
        private volatile int count = 0;

        public InstrumentedExceptionStrategy(MuleContext muleContext) {
            super(muleContext);
        }

        public void handleException(Exception exception) {
            ++this.count;
            super.handleException(exception);
        }

        public int getCount() {
            return this.count;
        }
    }
}

