/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.FutureMessageResult;
import org.mule.api.MuleException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class FutureMessageResultTestCase
extends AbstractMuleContextTestCase {
    private static Callable Dummy = new Callable(){

        public Object call() {
            return null;
        }
    };
    private volatile boolean wasCalled;

    @Test
    public void testCreation() {
        try {
            new FutureMessageResult(null, muleContext);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FutureMessageResult f = new FutureMessageResult(Dummy, muleContext);
            f.setExecutor(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExecute() throws ExecutionException, InterruptedException, MuleException {
        Callable c = new Callable(){

            public Object call() {
                FutureMessageResultTestCase.this.wasCalled = true;
                return null;
            }
        };
        FutureMessageResult f = new FutureMessageResult(c, muleContext);
        f.execute();
        Assert.assertNull((Object)f.getMessage());
        Assert.assertTrue((boolean)this.wasCalled);
    }

    @Test
    public void testExecuteWithShutdownExecutor() {
        ExecutorService e = Executors.newCachedThreadPool();
        e.shutdown();
        FutureMessageResult f = new FutureMessageResult(Dummy, muleContext);
        f.setExecutor((Executor)e);
        try {
            f.execute();
            Assert.fail();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteWithTimeout() throws ExecutionException, InterruptedException, MuleException {
        Callable c = new Callable(){

            public Object call() throws InterruptedException {
                Thread.sleep(3000L);
                FutureMessageResultTestCase.this.wasCalled = true;
                return null;
            }
        };
        FutureMessageResult f = new FutureMessageResult(c, muleContext);
        f.execute();
        try {
            f.getMessage(500L);
            Assert.fail();
        }
        catch (TimeoutException tex) {
            f.cancel(true);
        }
        finally {
            Assert.assertFalse((boolean)this.wasCalled);
        }
    }
}

