/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.processor.NamedStageNameSource;
import org.mule.api.processor.StageNameSource;
import org.mule.tck.size.SmallTest;

@SmallTest
public class NamedStageNameSourceTest {
    private static final String OWNER = "owner";
    private static final String NAME = "name";

    @Test
    public void getName() {
        int count = 10;
        NamedStageNameSource source = new NamedStageNameSource(OWNER, NAME);
        for (int i = 0; i < 10; ++i) {
            junit.framework.Assert.assertEquals((String)String.format("%s.%s", OWNER, NAME), (String)source.getName());
        }
    }

    @Test
    public void threadSafe() throws Exception {
        int count = 10;
        NamedStageNameSource source = new NamedStageNameSource(OWNER, NAME);
        final Set names = Collections.synchronizedSet(new HashSet());
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            new Thread((StageNameSource)source, latch){
                final /* synthetic */ StageNameSource val$source;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$source = stageNameSource;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    names.add(this.val$source.getName());
                    this.val$latch.countDown();
                }
            }.start();
        }
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        junit.framework.Assert.assertEquals((int)1, (int)names.size());
    }
}

