/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.Flow;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class FlowProcessingStrategyTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContext muleContext;
    @Mock
    private MuleConfiguration configuration;
    private AbstractPipeline flow;

    @Before
    public void before() {
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.configuration);
        this.createFlow();
    }

    @Test
    public void fixedProcessingStrategyIsHonoured() throws Exception {
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        this.createFlow();
        this.flow.setProcessingStrategy(processingStrategy);
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void defaultProcessingStrategyInConfigIsHonoured() throws Exception {
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategy()).thenReturn((Object)processingStrategy);
        this.createFlow();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void fixedProcessingStrategyTakesPrecedenceOverConfig() throws Exception {
        ProcessingStrategy configProcessingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)this.configuration.getDefaultProcessingStrategy()).thenReturn((Object)configProcessingStrategy);
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        this.createFlow();
        this.flow.setProcessingStrategy(processingStrategy);
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)processingStrategy)));
    }

    @Test
    public void createDefaultProcessingStrategyIfNoneSpecified() throws Exception {
        this.flow.initialise();
        Assert.assertThat((Object)this.flow.getProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(DefaultFlowProcessingStrategy.class)));
    }

    private void createFlow() {
        this.flow = new Flow("test", this.muleContext);
    }
}

