/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.notification.FlowCallStack;
import org.mule.api.context.notification.ProcessorsTrace;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.notification.DefaultFlowCallStack;
import org.mule.context.notification.DefaultProcessorsTrace;
import org.mule.context.notification.MessageProcessingFlowTraceManager;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MessageProcessingFlowTraceManagerTestCase
extends AbstractMuleTestCase {
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static QName sourceFileNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName");
    private static QName sourceFileLineAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine");
    private static final String NESTED_FLOW_NAME = "nestedFlow";
    private static final String ROOT_FLOW_NAME = "rootFlow";
    private static final String APP_ID = "MessageProcessingFlowTraceManagerTestCase";
    private static boolean originalFlowTrace;
    private MessageProcessingFlowTraceManager manager;

    @BeforeClass
    public static void beforeClass() {
        originalFlowTrace = DefaultMuleConfiguration.flowTrace;
        DefaultMuleConfiguration.flowTrace = true;
    }

    @AfterClass
    public static void afterClass() {
        DefaultMuleConfiguration.flowTrace = originalFlowTrace;
    }

    @Before
    public void before() {
        this.manager = new MessageProcessingFlowTraceManager();
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration config = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)config.getId()).thenReturn((Object)APP_ID);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)config);
        this.manager.setMuleContext(context);
    }

    @Test
    public void newFlowInvocation() {
        MuleEvent event = this.buildEvent("newFlowInvocation");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void nestedFlowInvocations() {
        MuleEvent event = this.buildEvent("nestedFlowInvocations");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "nestedFlow_ref"));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(event, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        String rootEntry = "at " + flowName + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ")";
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at nestedFlow" + System.lineSeparator() + rootEntry)));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)rootEntry));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void newComponentCall() {
        MuleEvent event = this.buildEvent("newComponentCall");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)"at rootFlow"));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/comp"));
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)"at rootFlow(/comp @ MessageProcessingFlowTraceManagerTestCase)"));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
    }

    protected String getContextInfo(MuleEvent event) {
        return (String)this.manager.getContextInfo(event, null).get("FlowStack");
    }

    @Test
    public void newAnnotatedComponentCall() {
        MuleEvent event = this.buildEvent("newAnnotatedComponentCall");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        AnnotatedObject annotatedMessageProcessor = (AnnotatedObject)Mockito.mock(MessageProcessor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{AnnotatedObject.class}));
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(docNameAttrName)).thenReturn((Object)"annotatedName");
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(sourceFileNameAttrName)).thenReturn((Object)"muleApp.xml");
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(sourceFileLineAttrName)).thenReturn((Object)10);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)annotatedMessageProcessor, "/comp"));
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName + "(/comp @ " + APP_ID + ":muleApp.xml:10 (annotatedName))")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void splitStack() {
        MuleEvent event = this.buildEvent("newAnnotatedComponentCall");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/comp"));
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName + "(/comp @ " + APP_ID + ")")));
        MuleEvent eventCopy = this.buildEvent("newAnnotatedComponentCall", event.getFlowCallStack().clone(), event.getProcessorsTrace());
        Assert.assertThat((Object)this.getContextInfo(eventCopy), (Matcher)CoreMatchers.is((Object)("at " + flowName + "(/comp @ " + APP_ID + ")")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        String asyncFlowName = "asyncFlow";
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowName));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/asyncComp"));
        Assert.assertThat((Object)this.getContextInfo(eventCopy), (Matcher)CoreMatchers.is((Object)("at " + asyncFlowName + "(/asyncComp @ " + APP_ID + ")" + System.lineSeparator() + "at " + flowName + "(/comp @ " + APP_ID + ")")));
    }

    @Test
    public void splitStackEnd() {
        MuleEvent event = this.buildEvent("newAnnotatedComponentCall");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/comp"));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        MuleEvent eventCopy = this.buildEvent("newAnnotatedComponentCall", flowCallStack.clone(), event.getProcessorsTrace());
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        String asyncFlowName = "asyncFlow";
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowName));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/asyncComp"));
        Assert.assertThat((Object)event.getProcessorsTrace(), this.hasExecutedProcessors("/comp @ MessageProcessingFlowTraceManagerTestCase", "/asyncComp @ MessageProcessingFlowTraceManagerTestCase"));
    }

    @Test
    public void joinStack() {
        MuleEvent event = this.buildEvent("joinStack");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/scatter-gather"));
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName + "(/scatter-gather @ " + APP_ID + ")")));
        MuleEvent eventCopy0 = this.buildEvent("joinStack_0", event.getFlowCallStack().clone(), event.getProcessorsTrace());
        MuleEvent eventCopy1 = this.buildEvent("joinStack_1", event.getFlowCallStack().clone(), event.getProcessorsTrace());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/route_0"));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, (MessageProcessor)Mockito.mock(MessageProcessor.class), "nestedFlow_ref"));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/route_1"));
        Assert.assertThat((Object)this.getContextInfo(eventCopy1), (Matcher)CoreMatchers.is((Object)("at nestedFlow(/route_1 @ MessageProcessingFlowTraceManagerTestCase)" + System.lineSeparator() + "at " + ROOT_FLOW_NAME + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ")")));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)("at " + flowName + "(/scatter-gather @ " + APP_ID + ")")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void joinStackEnd() {
        MuleEvent event = this.buildEvent("joinStack");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, flowName);
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/scatter-gather"));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        MuleEvent eventCopy0 = this.buildEvent("joinStack_0", flowCallStack.clone(), event.getProcessorsTrace());
        MuleEvent eventCopy1 = this.buildEvent("joinStack_1", flowCallStack.clone(), event.getProcessorsTrace());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/route_0"));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, (MessageProcessor)Mockito.mock(MessageProcessor.class), "nestedFlow_ref"));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, (MessageProcessor)Mockito.mock(MessageProcessor.class), "/route_1"));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)event.getProcessorsTrace(), this.hasExecutedProcessors("/scatter-gather @ MessageProcessingFlowTraceManagerTestCase", "/route_0 @ MessageProcessingFlowTraceManagerTestCase", "nestedFlow_ref @ MessageProcessingFlowTraceManagerTestCase", "/route_1 @ MessageProcessingFlowTraceManagerTestCase"));
    }

    @Test
    public void mixedEvents() {
        MuleEvent event1 = this.buildEvent("mixedEvents_1");
        MuleEvent event2 = this.buildEvent("mixedEvents_2");
        String flowName = ROOT_FLOW_NAME;
        PipelineMessageNotification pipelineNotification1 = this.buildPipelineNotification(event1, flowName);
        PipelineMessageNotification pipelineNotification2 = this.buildPipelineNotification(event2, flowName);
        Assert.assertThat((Object)this.getContextInfo(event1), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        Assert.assertThat((Object)this.getContextInfo(event2), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        Assert.assertThat((Object)this.getContextInfo(event2), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        this.manager.onPipelineNotificationComplete(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2), (Matcher)CoreMatchers.is((Object)("at " + flowName)));
        this.manager.onPipelineNotificationComplete(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2), (Matcher)CoreMatchers.is((Object)""));
    }

    protected MuleEvent buildEvent(String eventId) {
        return this.buildEvent(eventId, (FlowCallStack)new DefaultFlowCallStack(), (ProcessorsTrace)new DefaultProcessorsTrace());
    }

    protected MuleEvent buildEvent(String eventId, FlowCallStack flowStack, ProcessorsTrace processorsTrace) {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)event.getId()).thenReturn((Object)eventId);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)flowStack);
        Mockito.when((Object)event.getProcessorsTrace()).thenReturn((Object)processorsTrace);
        return event;
    }

    protected MessageProcessorNotification buildProcessorNotification(MuleEvent event, MessageProcessor processor, String processorPath) {
        MessageProcessorNotification processorNotification = (MessageProcessorNotification)Mockito.mock(MessageProcessorNotification.class);
        Mockito.when((Object)processorNotification.getProcessor()).thenReturn((Object)processor);
        Mockito.when((Object)processorNotification.getProcessorPath()).thenReturn((Object)processorPath);
        Mockito.when((Object)processorNotification.getSource()).thenReturn((Object)event);
        return processorNotification;
    }

    protected PipelineMessageNotification buildPipelineNotification(MuleEvent event, String flowName) {
        PipelineMessageNotification pipelineNotification = (PipelineMessageNotification)Mockito.mock(PipelineMessageNotification.class);
        Mockito.when((Object)pipelineNotification.getSource()).thenReturn((Object)event);
        Mockito.when((Object)pipelineNotification.getResourceIdentifier()).thenReturn((Object)flowName);
        return pipelineNotification;
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessors(final String ... expectedProcessors) {
        return new TypeSafeMatcher<ProcessorsTrace>(){
            private List<Matcher> failed = new ArrayList<Matcher>();

            protected boolean matchesSafely(ProcessorsTrace processorsTrace) {
                Matcher sizeMatcher = IsCollectionWithSize.hasSize((int)expectedProcessors.length);
                if (!sizeMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                    this.failed.add(sizeMatcher);
                }
                int i = 0;
                for (String expectedProcessor : expectedProcessors) {
                    Matcher processorItemMatcher = CoreMatchers.is((Object)expectedProcessor);
                    if (!processorItemMatcher.matches(processorsTrace.getExecutedProcessors().get(i))) {
                        this.failed.add(processorItemMatcher);
                    }
                    ++i;
                }
                return this.failed.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendValue(Arrays.asList(expectedProcessors));
            }

            protected void describeMismatchSafely(ProcessorsTrace item, Description description) {
                description.appendText("was ").appendValue((Object)item.getExecutedProcessors());
            }
        };
    }
}

