/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.io.Serializable;
import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.el.mvel.datatype.MvelEnricherDataTypePropagator;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.TypedValue;

public class MvelEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final String MEL_EXPRESSION = "foo = bar";
    private final MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
    private final TypedValue typedValue = new TypedValue((Object)"Test Message", DataType.STRING_DATA_TYPE);
    private final EnricherDataTypePropagator propagator1 = (EnricherDataTypePropagator)Mockito.mock(EnricherDataTypePropagator.class);
    private final EnricherDataTypePropagator propagator2 = (EnricherDataTypePropagator)Mockito.mock(EnricherDataTypePropagator.class);

    @Test
    public void invokesDataTypeAllPropagators() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        ArrayList<EnricherDataTypePropagator> propagators = new ArrayList<EnricherDataTypePropagator>();
        propagators.add(this.propagator1);
        propagators.add(this.propagator2);
        MvelEnricherDataTypePropagator dataTypePropagator = new MvelEnricherDataTypePropagator(propagators);
        dataTypePropagator.propagate(this.typedValue, this.message, (Serializable)compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator1)).propagate(this.message, this.typedValue, compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator2)).propagate(this.message, this.typedValue, compiledExpression);
    }

    @Test
    public void stopsCheckingDataTypePropagatorsAfterSuccessfulPropagation() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        ArrayList<EnricherDataTypePropagator> propagators = new ArrayList<EnricherDataTypePropagator>();
        propagators.add(this.propagator1);
        Mockito.when((Object)this.propagator1.propagate(this.message, this.typedValue, compiledExpression)).thenReturn((Object)true);
        propagators.add(this.propagator2);
        MvelEnricherDataTypePropagator dataTypePropagator = new MvelEnricherDataTypePropagator(propagators);
        dataTypePropagator.propagate(this.typedValue, this.message, (Serializable)compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator1)).propagate(this.message, this.typedValue, compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator2, (VerificationMode)Mockito.never())).propagate(this.message, this.typedValue, compiledExpression);
    }

    private CompiledExpression compileMelExpression() {
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        return (CompiledExpression)MVEL.compileExpression((String)MEL_EXPRESSION, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
    }
}

