/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.io.Serializable;
import java.util.Collections;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.MvelDataTypeResolver;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

public class MvelExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String EXPRESSION_VALUE = "bar";
    public static final String MEL_EXPRESSION = "someExpression";
    private MvelDataTypeResolver dataTypeResolver;

    @Test
    public void returnsDefaultDataTypeForNonNullValue() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        MuleEvent testEvent = MvelExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        this.dataTypeResolver = new MvelDataTypeResolver(Collections.EMPTY_LIST);
        MatcherAssert.assertThat((Object)this.dataTypeResolver.resolve((Object)EXPRESSION_VALUE, testEvent.getMessage(), (Serializable)compiledExpression), DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void returnsDefaultDataTypeForNullValue() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        MuleEvent testEvent = MvelExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        this.dataTypeResolver = new MvelDataTypeResolver();
        MatcherAssert.assertThat((Object)this.dataTypeResolver.resolve(null, testEvent.getMessage(), (Serializable)compiledExpression), DataTypeMatcher.like(Object.class, "*/*", null));
    }

    private CompiledExpression compileMelExpression() {
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        return (CompiledExpression)MVEL.compileExpression((String)MEL_EXPRESSION, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
    }
}

