/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.el.mvel.datatype.PropertyEnricherDataTypePropagator;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class PropertyEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    private static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private final EnricherDataTypePropagator dataTypePropagator = new PropertyEnricherDataTypePropagator();

    @Test
    public void propagatesDataTypeForInlinedInvocationProperty() throws Exception {
        this.doInlinePropertyDataTypePropagationTest(PropertyScope.INVOCATION);
    }

    @Test
    public void propagatesDataTypeForInlinedSessionProperty() throws Exception {
        this.doInlinePropertyDataTypePropagationTest(PropertyScope.SESSION);
    }

    private void doInlinePropertyDataTypePropagationTest(PropertyScope scope) throws Exception {
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo = 'unused'", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        MuleEvent testEvent = PropertyEnricherDataTypePropagatorTestCase.getTestEvent("Test Message");
        testEvent.getMessage().setProperty("foo", (Object)"bar", scope);
        this.dataTypePropagator.propagate(testEvent.getMessage(), new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        MatcherAssert.assertThat((Object)testEvent.getMessage().getPropertyDataType("foo", scope), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }
}

