/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.el.mvel.datatype.PropertyExpressionDataTypeResolver;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;

public class PropertyExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String EXPRESSION_VALUE = "bar";
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private final ExpressionDataTypeResolver expressionDataTypeResolver = new PropertyExpressionDataTypeResolver();

    @Test
    public void returnsInlineFlowVarDataType() throws Exception {
        String expression = "foo";
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        MuleEvent testEvent = PropertyExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        testEvent.getMessage().setProperty("foo", (Object)EXPRESSION_VALUE, PropertyScope.INVOCATION, expectedDataType);
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(testEvent.getMessage(), compiledExpression), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    @Test
    public void returnsInlineSessionPropertyDataType() throws Exception {
        String expression = "foo";
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)"foo", (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        MuleEvent testEvent = PropertyExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        testEvent.getMessage().setProperty("foo", (Object)EXPRESSION_VALUE, PropertyScope.SESSION, expectedDataType);
        MatcherAssert.assertThat((Object)this.expressionDataTypeResolver.resolve(testEvent.getMessage(), compiledExpression), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }
}

