/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transaction.Transaction;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class ErrorHandlingExecutionTemplateTestCase
extends AbstractMuleTestCase {
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    @Mock
    private MuleEvent RETURN_VALUE;
    @Mock
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockEvent;
    @Spy
    protected TestTransaction mockTransaction = new TestTransaction(this.mockMuleContext);
    @Mock
    protected MessagingExceptionHandler mockMessagingExceptionHandler;

    @Before
    public void unbindTransaction() throws Exception {
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        Mockito.when((Object)this.mockMessagingException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
    }

    @Test
    public void testSuccessfulExecution() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        Object result = executionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(this.RETURN_VALUE));
        Assert.assertThat((Object)((MuleEvent)result), (Matcher)Is.is((Object)this.RETURN_VALUE));
    }

    private ExecutionTemplate createExceptionHandlingTransactionTemplate() {
        return ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate((MuleContext)this.mockMuleContext, (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
    }

    @Test
    public void testFailureException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        MuleEvent mockResultEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((Exception)((Object)this.mockMessagingException), this.mockEvent)).thenReturn((Object)mockResultEvent);
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockResultEvent);
        }
    }

    @Test
    public void testTransactionIsMarkedRollbackOnExceptionByDefault() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, null);
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnEveryException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "*");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnMatcherRegexPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.ap*");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnClassHierarchyPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.api.MuleException+");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testTransactionIsNotRollbackOnClassExactlyPatternException() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener(null, "org.mule.api.MessagingException");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(new MessagingException(this.mockEvent, null)));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
    }

    @Test
    public void testTransactionIsRollbackOnPatternAppliesToRollbackAndCommit() throws Exception {
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        this.configureExceptionListener("org.mule.api.MuleException+", "org.mule.api.MessagingException");
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
    }

    @Test
    public void testSuspendedTransactionNotResumedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testSuspendedTransactionNotResumedAndNewTransactionResolvedOnException() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        Transaction mockNewTransaction = (Transaction)Mockito.spy((Object)((Object)new TestTransaction(this.mockMuleContext)));
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, mockNewTransaction));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).resume();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).setRollbackOnly();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).commit();
        ((Transaction)Mockito.verify((Object)mockNewTransaction, (VerificationMode)VerificationModeFactory.times((int)1))).setRollbackOnly();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionIsResolved() throws Exception {
        this.configureExceptionListener(null, null);
        ExecutionTemplate executionTemplate = this.createExceptionHandlingTransactionTemplate();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).setRollbackOnly();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    private void configureExceptionListener(final String rollbackFilter, final String commitFilter) {
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent);
        Mockito.when((Object)this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
        Mockito.when((Object)this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((Exception)Matchers.any(MessagingException.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DefaultMessagingExceptionStrategy defaultMessagingExceptionStrategy = new DefaultMessagingExceptionStrategy();
                defaultMessagingExceptionStrategy.setMuleContext(ErrorHandlingExecutionTemplateTestCase.this.mockMuleContext);
                if (rollbackFilter != null) {
                    defaultMessagingExceptionStrategy.setRollbackTxFilter(new WildcardFilter(rollbackFilter));
                }
                if (commitFilter != null) {
                    defaultMessagingExceptionStrategy.setCommitTxFilter(new WildcardFilter(commitFilter));
                }
                defaultMessagingExceptionStrategy.handleException((Exception)invocationOnMock.getArguments()[0], (MuleEvent)invocationOnMock.getArguments()[1]);
                return null;
            }
        });
    }
}

