/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.execution.TransactionalExecutionTemplateTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplateTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class TransactionalErrorHandlingExecutionTemplateTestCase
extends TransactionalExecutionTemplateTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TransactionConfig mockTransactionConfig;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TransactionFactory mockTransactionFactory;

    @Before
    public void setUp() throws TransactionException {
        Mockito.when((Object)this.mockTransactionConfig.getFactory()).thenReturn((Object)this.mockTransactionFactory);
        Mockito.when((Object)this.mockTransactionFactory.beginTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Transaction>(){

            public Transaction answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockTransaction);
                return TransactionalErrorHandlingExecutionTemplateTestCase.this.mockTransaction;
            }
        });
    }

    @Test
    public void testActionNoneAndXaTxAndFailureInCallback() throws Exception {
        this.mockTransaction.setXA(true);
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = new MuleTransactionConfig(0);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        MuleEvent mockExceptionListenerResultEvent = this.configureExceptionListenerCall();
        try {
            executionTemplate.execute(this.getFailureTransactionCallback());
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            ((MessagingException)((Object)Mockito.verify((Object)((Object)this.mockMessagingException)))).setProcessedEvent(mockExceptionListenerResultEvent);
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
    }

    @Test
    public void testActionAlwaysBeginAndSuspendXaTxAndFailureCallback() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
        MuleTransactionConfig config = this.createAlwaysBeginXaTransaction();
        ExecutionTemplate executionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        config.setFactory((TransactionFactory)new TestTransactionFactory((Transaction)this.mockNewTransaction));
        MuleEvent exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            executionTemplate.execute(this.getFailureTransactionCallback());
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockNewTransaction)))).rollback();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).resume();
        Assert.assertThat((Object)((Object)((TestTransaction)TransactionCoordination.getInstance().getTransaction())), (Matcher)Is.is((Object)((Object)this.mockTransaction)));
    }

    @Test
    public void testActionAlwaysJoinAndExternalTxAndFailureCallback() throws Exception {
        MuleTransactionConfig config = new MuleTransactionConfig(3);
        config.setInteractWithExternal(true);
        this.mockExternalTransactionFactory = (ExternalTransactionAwareTransactionFactory)Mockito.mock(ExternalTransactionAwareTransactionFactory.class);
        config.setFactory((TransactionFactory)this.mockExternalTransactionFactory);
        Mockito.when((Object)this.mockExternalTransactionFactory.joinExternalTransaction(this.mockMuleContext)).thenAnswer((Answer)new Answer<Transaction>(){

            public Transaction answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().bindTransaction((Transaction)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockTransaction);
                return TransactionalErrorHandlingExecutionTemplateTestCase.this.mockTransaction;
            }
        });
        ExecutionTemplate transactionTemplate = this.createExecutionTemplate((TransactionConfig)config);
        MuleEvent exceptionListenerResult = this.configureExceptionListenerCall();
        try {
            transactionTemplate.execute(this.getFailureTransactionCallback());
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)exceptionListenerResult));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInnerTransactionCreatedAndResolved() throws Exception {
        ExecutionTemplate transactionTemplate = this.createExecutionTemplate((TransactionConfig)new MuleTransactionConfig());
        this.configureExceptionListenerCall();
        Mockito.when((Object)this.mockMessagingException.causedRollback()).thenReturn((Object)false);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInnerTransactionCreatedAndNotResolved() throws Exception {
        TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate((MuleContext)this.mockMuleContext, (TransactionConfig)new MuleTransactionConfig(), (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
        this.configureCatchExceptionListenerCall();
        Mockito.when((Object)this.mockMessagingException.causedRollback()).thenReturn((Object)false);
        try {
            transactionTemplate.execute(TransactionTemplateTestUtils.getFailureTransactionCallbackStartsTransaction(this.mockMessagingException, (Transaction)this.mockTransaction));
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).commit();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction), (VerificationMode)VerificationModeFactory.times((int)0)))).rollback();
        Assert.assertThat((Object)TransactionCoordination.getInstance().getTransaction(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void transactionCommitFailsCallsExceptionHandler() throws Exception {
        Mockito.when((Object)this.mockTransactionConfig.getAction()).thenReturn((Object)1);
        ExecutionTemplate executionTemplate = this.createExecutionTemplate(this.mockTransactionConfig);
        ((TestTransaction)((Object)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().unbindTransaction((Transaction)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockTransaction);
                throw new RuntimeException();
            }
        }).when((Object)this.mockTransaction))).commit();
        this.configureCatchExceptionListenerCall();
        try {
            executionTemplate.execute(TransactionTemplateTestUtils.getEmptyTransactionCallback(this.mockEvent));
            Assert.fail((String)"MessagingException must be thrown");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getEvent(), (Matcher)Is.is((Object)this.mockEvent));
        }
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)this.mockTransaction)))).commit();
        ((MessagingExceptionHandler)Mockito.verify((Object)this.mockMessagingExceptionHandler)).handleException((Exception)Matchers.any(MessagingException.class), (MuleEvent)Matchers.eq((Object)this.mockEvent));
    }

    @Override
    protected ExecutionTemplate createExecutionTemplate(TransactionConfig config) {
        return TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate((MuleContext)this.mockMuleContext, (TransactionConfig)config, (MessagingExceptionHandler)this.mockMessagingExceptionHandler);
    }

    private MuleEvent configureExceptionListenerCall() {
        final MuleEvent mockResultEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((Exception)((Object)this.mockMessagingException), this.mockEvent)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DefaultMessagingExceptionStrategy defaultMessagingExceptionStrategy = new DefaultMessagingExceptionStrategy();
                Mockito.when((Object)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
                Mockito.when((Object)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
                defaultMessagingExceptionStrategy.setMuleContext(TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext);
                defaultMessagingExceptionStrategy.handleException((Exception)invocationOnMock.getArguments()[0], (MuleEvent)invocationOnMock.getArguments()[1]);
                return mockResultEvent;
            }
        });
        return mockResultEvent;
    }

    private MuleEvent configureCatchExceptionListenerCall() {
        final MuleEvent mockResultEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockMessagingException.getEvent()).thenReturn((Object)this.mockEvent).thenReturn((Object)mockResultEvent);
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((Exception)((Object)this.mockMessagingException), this.mockEvent)).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                CatchMessagingExceptionStrategy exceptionStrategy = new CatchMessagingExceptionStrategy();
                exceptionStrategy.setMuleContext(TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext);
                Mockito.when((Object)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext.getNotificationManager()).thenReturn(Mockito.mock(ServerNotificationManager.class));
                Mockito.when((Object)TransactionalErrorHandlingExecutionTemplateTestCase.this.mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
                exceptionStrategy.handleException((Exception)invocationOnMock.getArguments()[0], (MuleEvent)invocationOnMock.getArguments()[1]);
                return mockResultEvent;
            }
        });
        return mockResultEvent;
    }

    protected ExecutionCallback<MuleEvent> getFailureTransactionCallback() throws Exception {
        return TransactionTemplateTestUtils.getFailureTransactionCallback(this.mockMessagingException);
    }

    private MuleTransactionConfig createAlwaysBeginXaTransaction() throws TransactionException {
        return this.createTransactionConfig(true);
    }

    private MuleTransactionConfig createTransactionConfig(boolean isXa) throws TransactionException {
        this.mockTransaction.setXA(isXa);
        return new MuleTransactionConfig(1);
    }
}

