/*
 * Decompiled with CFR 0.152.
 */
package org.mule.keygenerator;

import java.io.NotSerializableException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.keygenerator.SHA256MuleEventKeyGenerator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SHA256MuleEventKeyGeneratorTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_INPUT = "TEST";
    private static final String TEST_HASH = "94ee059335e587e501cc4bf90613e0814f00a7b08bc7c648fd865a2af6a22cc2";
    private SHA256MuleEventKeyGenerator keyGenerator = new SHA256MuleEventKeyGenerator();

    @Test
    public void generatesKeyApplyingSHA256ToPayload() throws Exception {
        MuleEvent event = SHA256MuleEventKeyGeneratorTestCase.getTestEvent(TEST_INPUT);
        String key = (String)((Object)this.keyGenerator.generateKey(event));
        Assert.assertEquals((Object)TEST_HASH, (Object)key);
    }

    @Test(expected=NotSerializableException.class)
    public void failsToGenerateKeyWhenCannotReadPayload() throws Exception {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)event.getMessageAsBytes()).thenThrow(new Throwable[]{new DefaultMuleException("Fail")});
        this.keyGenerator.generateKey(event);
    }
}

