/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.ExplicitMethodEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;

public class ExplicitMethodEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testMethodSetPass() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodSetMatchFirst() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        resolver.addMethod("someSetter");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodNotFound() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("noMethod");
        resolver.addMethod("noMethod2");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testNoMethodSet() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        try {
            resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
            Assert.fail((String)"method property is not set, this should cause an error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("wash");
        MuleEventContext ctx = ExplicitMethodEntryPointResolverTestCase.getTestEventContext(new Apple());
        InvocationResult result = resolver.invoke((Object)new TestFruitCleaner(), ctx);
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testMethodPropertyParameterNull() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someOtherBusinessMethod");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext(new Object[]{null, "blah"}));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

